/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import org.mitre.caasd.commons.Pair;

public class EditDistance {
    private final String startString;
    private final String endString;
    private final HashMap<Pair<Integer, Integer>, Integer> knownValues;

    public static double similarity(String one, String two) {
        double editDist = EditDistance.between(one, two);
        double length = Doubles.max((double[])new double[]{one.length(), two.length()});
        double difference = length - editDist;
        Preconditions.checkState((length >= editDist ? 1 : 0) != 0, (Object)"I think this should always be true");
        return difference / length;
    }

    public static int between(String one, String two) {
        EditDistance ed = new EditDistance(one, two);
        return ed.computeEditDistance();
    }

    EditDistance(String startString, String endString) {
        this.startString = ((String)Preconditions.checkNotNull((Object)startString)).toLowerCase();
        this.endString = ((String)Preconditions.checkNotNull((Object)endString)).toLowerCase();
        this.knownValues = Maps.newHashMap();
        this.knownValues.put(Pair.of(0, 0), 0);
    }

    private int editDistance(int i, int j) {
        Pair<Integer, Integer> key = Pair.of(i, j);
        if (this.knownValues.containsKey(Pair.of(i, j))) {
            return this.knownValues.get(key);
        }
        int value = this.computeDistanceAt(i, j);
        this.knownValues.put(key, value);
        return value;
    }

    private int computeDistanceAt(int i, int j) {
        if (i == 0) {
            return j;
        }
        if (j == 0) {
            return i;
        }
        int incrementCost = this.startString.charAt(i - 1) == this.endString.charAt(j - 1) ? 0 : 1;
        return Ints.min((int[])new int[]{this.editDistance(i - 1, j) + 1, this.editDistance(i, j - 1) + 1, this.editDistance(i - 1, j - 1) + incrementCost});
    }

    public int computeEditDistance() {
        return this.editDistance(this.startString.length(), this.endString.length());
    }
}

