/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import org.mitre.caasd.commons.util.ExceptionHandler;

public class ErrorCatchingTask
implements Runnable {
    private static final int EXIT_ERROR_CODE = 123456789;
    private final Runnable runMe;
    private final ExceptionHandler exceptionHandler;
    private final ErrorHandlingPolicy errorHandler;

    public ErrorCatchingTask(Runnable runMe, ExceptionHandler exceptionHandler, ErrorHandlingPolicy errorHandler) {
        this.runMe = (Runnable)Preconditions.checkNotNull((Object)runMe, (Object)"The input Runnable cannot be null");
        this.exceptionHandler = (ExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler, (Object)"The ErrorHandler cannot be null");
        this.errorHandler = errorHandler;
    }

    public ErrorCatchingTask(Runnable runMe, ExceptionHandler exceptionHandler) {
        this(runMe, exceptionHandler, ErrorCatchingTask.killJvmOnError(123456789));
    }

    @Override
    public void run() {
        try {
            this.runMe.run();
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
        catch (Error err) {
            this.errorHandler.handleError(err);
            throw err;
        }
    }

    public static ErrorHandlingPolicy killJvmOnError(int errorCode) {
        return error -> {
            System.err.println("Killing JVM from ErrorCatchingTask due to unhandled Error");
            error.printStackTrace();
            System.exit(errorCode);
        };
    }

    public static ErrorHandlingPolicy ignoreAndRethrow() {
        return error -> {};
    }

    @FunctionalInterface
    public static interface ErrorHandlingPolicy {
        public void handleError(Error var1);
    }
}

