/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteredIterator<T>
implements Iterator<T> {
    private final Iterator<T> innerIterator;
    private final Predicate<T> predicate;
    private T next;

    public FilteredIterator(Iterator<T> iter, Predicate<T> predicate) {
        Preconditions.checkNotNull(iter);
        Preconditions.checkNotNull(predicate);
        this.innerIterator = iter;
        this.predicate = predicate;
        this.next = this.findNext();
    }

    public static <E> Iterator<E> filter(Iterator<E> iter, Predicate<E> predicate) {
        return new FilteredIterator<E>(iter, predicate);
    }

    private T findNext() {
        while (this.innerIterator.hasNext()) {
            T candidate = this.innerIterator.next();
            if (!this.predicate.test(candidate)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T returnMe = this.next;
        this.next = this.findNext();
        return returnMe;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

