/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.mitre.caasd.commons.util.PropertyUtils;

public final class ImmutableConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableMap<String, String> propertyMap;

    public ImmutableConfig(File propertiesFile, Collection<String> requiredProps) {
        this(PropertyUtils.loadProperties(propertiesFile), Objects.requireNonNull(requiredProps, "The requiredProps cannot be null"));
    }

    public ImmutableConfig(File propertiesFile) {
        this(PropertyUtils.loadProperties(propertiesFile));
    }

    public ImmutableConfig(Properties props) {
        this(props, (Collection<String>)Collections.emptyList());
    }

    public ImmutableConfig(Properties props, Collection<String> requiredPropertyKeys) {
        this((Map<String, String>)ImmutableConfig.asImmutableMap(props), requiredPropertyKeys);
    }

    public ImmutableConfig(Map<String, String> properties) {
        this(properties, Collections.emptyList());
    }

    public ImmutableConfig(Map<String, String> properties, Collection<String> requiredPropertyKeys) {
        Objects.requireNonNull(properties);
        Objects.requireNonNull(requiredPropertyKeys);
        this.propertyMap = ImmutableMap.copyOf(properties);
        this.verifyKeysExist(requiredPropertyKeys);
    }

    public void verifyKeysExist(Collection<String> requiredPropertyKeys) {
        requiredPropertyKeys.forEach(this::getRequired);
    }

    private String getRequired(String propertyName) {
        String value = (String)this.propertyMap.get((Object)propertyName);
        if (value != null) {
            return value.trim();
        }
        throw new PropertyUtils.MissingPropertyException(propertyName);
    }

    public String getString(String propertyName) {
        return this.getRequired(propertyName);
    }

    public byte getByte(String propertyName) {
        return Byte.parseByte(this.getRequired(propertyName));
    }

    public short getShort(String propertyName) {
        return Short.parseShort(this.getRequired(propertyName));
    }

    public int getInt(String propertyName) {
        return Integer.parseInt(this.getRequired(propertyName));
    }

    public long getLong(String propertyName) {
        return Long.parseLong(this.getRequired(propertyName));
    }

    public float getFloat(String propertyName) {
        return Float.parseFloat(this.getRequired(propertyName));
    }

    public double getDouble(String propertyName) {
        return Double.parseDouble(this.getRequired(propertyName));
    }

    public boolean getBoolean(String propertyName) {
        return Boolean.parseBoolean(this.getRequired(propertyName));
    }

    private Optional<String> getOptionalProperty(String propertyName) {
        String value = (String)this.propertyMap.get((Object)propertyName);
        if (value != null) {
            return Optional.of(value.trim());
        }
        return Optional.empty();
    }

    public Optional<String> getOptionalString(String propertyName) {
        return this.getOptionalProperty(propertyName);
    }

    public Optional<Byte> getOptionalByte(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.map(Byte::parseByte);
    }

    public Optional<Short> getOptionalShort(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.map(Short::parseShort);
    }

    public Optional<Integer> getOptionalInt(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.map(Integer::parseInt);
    }

    public Optional<Long> getOptionalLong(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.map(Long::parseLong);
    }

    public Optional<Float> getOptionalFloat(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.map(Float::parseFloat);
    }

    public Optional<Double> getOptionalDouble(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.map(Double::parseDouble);
    }

    public Optional<Boolean> getOptionalBoolean(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.map(Boolean::parseBoolean);
    }

    public static ImmutableMap<String, String> asImmutableMap(Properties props) {
        Objects.requireNonNull(props, "The input properties cannot be null");
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            builder.put((Object)key.trim(), (Object)value.trim());
        }
        return builder.build();
    }

    public ImmutableSortedSet<Map.Entry<String, String>> entrySet() {
        Comparator comparator = Map.Entry.comparingByKey();
        return ImmutableSortedSet.orderedBy(comparator).addAll((Iterable)this.propertyMap.entrySet()).build();
    }

    public ImmutableMap<String, String> rawMapping() {
        return this.propertyMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String SPACING = " : ";
        for (Map.Entry entry : this.entrySet()) {
            String propertyName = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(propertyName).append(SPACING).append(value).append("\n");
        }
        return sb.toString();
    }

    public Properties asProperties() {
        Properties props = new Properties();
        for (Map.Entry entry : this.propertyMap.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }
}

