/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import java.util.ConcurrentModificationException;
import java.util.concurrent.Callable;

public class ParallelismDetector {
    private boolean isMidExecution = false;

    public void run(Runnable task) {
        this.throwIfMidExecution();
        this.isMidExecution = true;
        try {
            task.run();
        }
        catch (Exception ex) {
            this.isMidExecution = false;
            throw ex;
        }
        this.isMidExecution = false;
    }

    public <T> T call(Callable<T> task) throws Exception {
        T output;
        this.throwIfMidExecution();
        this.isMidExecution = true;
        try {
            output = task.call();
        }
        catch (Exception ex) {
            this.isMidExecution = false;
            throw ex;
        }
        this.isMidExecution = false;
        return output;
    }

    private void throwIfMidExecution() {
        if (this.isMidExecution) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean isMidExecution() {
        return this.isMidExecution;
    }
}

