/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Partitioners {
    public static <T> List<List<T>> splitOnChange(List<T> data, Predicate<T> rule) {
        return data.stream().collect(Partitioners.newListCollector(rule));
    }

    public static <T> Collector<T, List<List<T>>, List<List<T>>> newListCollector(Predicate<T> pred) {
        return Partitioners.newListCollector(Function.identity(), pred);
    }

    public static <T, U> Collector<T, List<List<T>>, List<U>> newListCollector(Function<List<T>, U> partitionFinisher, Predicate<T> pred) {
        return Partitioners.newListCollector(partitionFinisher, Partitioners.toBiPredicate(pred));
    }

    public static <T> List<List<T>> splitOnPairwiseChange(List<T> data, BiPredicate<List<T>, T> rule) {
        return data.stream().collect(Partitioners.newListCollector(rule));
    }

    public static <T> Collector<T, List<List<T>>, List<List<T>>> newListCollector(BiPredicate<List<T>, T> pred) {
        return Partitioners.newListCollector(Function.identity(), pred);
    }

    public static <T, U> Collector<T, List<List<T>>, List<U>> newListCollector(Function<List<T>, U> partitionFinisher, BiPredicate<List<T>, T> pred) {
        Objects.requireNonNull(partitionFinisher);
        Objects.requireNonNull(pred);
        return new ListPartitioner<T, U>(partitionFinisher, Partitioners.predicatedConsumer(pred, ArrayList::new, ls -> (List)ls.get(ls.size() - 1)));
    }

    public static <T extends Comparable<? super T>> Collector<T, TreeSet<TreeSet<T>>, TreeSet<TreeSet<T>>> newTreeSetCollector(Predicate<T> pred) {
        return Partitioners.newTreeSetCollector(Comparator.comparing(TreeSet::first), Function.identity(), pred);
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>> Collector<T, TreeSet<TreeSet<T>>, TreeSet<U>> newTreeSetCollector(Function<TreeSet<T>, U> partitionFinisher, Predicate<T> pred) {
        return Partitioners.newTreeSetCollector(Comparator.naturalOrder(), partitionFinisher, pred);
    }

    public static <T extends Comparable<? super T>, U> Collector<T, TreeSet<TreeSet<T>>, TreeSet<U>> newTreeSetCollector(Comparator<U> comparator, Function<TreeSet<T>, U> partitionFinisher, Predicate<T> pred) {
        return Partitioners.newTreeSetCollector(comparator, partitionFinisher, Partitioners.toBiPredicate(pred));
    }

    public static <T extends Comparable<? super T>> Collector<T, TreeSet<TreeSet<T>>, TreeSet<TreeSet<T>>> newTreeSetCollector(BiPredicate<TreeSet<T>, T> pred) {
        return Partitioners.newTreeSetCollector(Comparator.comparing(TreeSet::first), Function.identity(), pred);
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>> Collector<T, TreeSet<TreeSet<T>>, TreeSet<U>> newTreeSetCollector(Function<TreeSet<T>, U> partitionFinisher, BiPredicate<TreeSet<T>, T> pred) {
        return Partitioners.newTreeSetCollector(Comparator.naturalOrder(), partitionFinisher, pred);
    }

    public static <T extends Comparable<? super T>, U> Collector<T, TreeSet<TreeSet<T>>, TreeSet<U>> newTreeSetCollector(Comparator<U> comparator, Function<TreeSet<T>, U> partitionFinisher, BiPredicate<TreeSet<T>, T> pred) {
        Objects.requireNonNull(partitionFinisher);
        Objects.requireNonNull(pred);
        return new TreeSetPartitioner<T, U>(comparator, partitionFinisher, Partitioners.predicatedConsumer(pred, TreeSet::new, TreeSet::last));
    }

    private static <T, C extends Collection<T>> BiPredicate<C, T> toBiPredicate(Predicate<T> predicate) {
        return (col, t2) -> predicate.test(col.iterator().next()) == predicate.test(t2);
    }

    private static <T, C extends Collection<T>, CC extends Collection<C>> BiConsumer<CC, T> predicatedConsumer(BiPredicate<C, T> pred, Supplier<C> supplier, Function<CC, C> lastCol) {
        return (x, y) -> {
            if (x.isEmpty()) {
                Collection col = (Collection)supplier.get();
                col.add(y);
                x.add(col);
                return;
            }
            Collection last = (Collection)lastCol.apply(x);
            if (pred.negate().test(last, y)) {
                Collection col = (Collection)supplier.get();
                col.add(y);
                x.add(col);
            } else {
                last.add(y);
            }
        };
    }

    private static final class TreeSetPartitioner<T extends Comparable<? super T>, U>
    implements Collector<T, TreeSet<TreeSet<T>>, TreeSet<U>> {
        private final Comparator<U> comparator;
        private final Function<TreeSet<T>, U> finisher;
        private final BiConsumer<TreeSet<TreeSet<T>>, T> accumulator;

        public TreeSetPartitioner(Comparator<U> comparator, Function<TreeSet<T>, U> finisher, BiConsumer<TreeSet<TreeSet<T>>, T> accumulator) {
            this.comparator = Objects.requireNonNull(comparator);
            this.finisher = Objects.requireNonNull(finisher);
            this.accumulator = Objects.requireNonNull(accumulator);
        }

        @Override
        public Supplier<TreeSet<TreeSet<T>>> supplier() {
            return () -> new TreeSet<TreeSet>(Comparator.comparing(TreeSet::first));
        }

        @Override
        public BiConsumer<TreeSet<TreeSet<T>>, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public BinaryOperator<TreeSet<TreeSet<T>>> combiner() {
            return (r1, r2) -> {
                r1.addAll(r2);
                return r1;
            };
        }

        @Override
        public Function<TreeSet<TreeSet<T>>, TreeSet<U>> finisher() {
            return s -> s.stream().map(this.finisher).collect(Collectors.toCollection(() -> new TreeSet<U>(this.comparator)));
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT});
        }
    }

    private static final class ListPartitioner<T, U>
    implements Collector<T, List<List<T>>, List<U>> {
        private final Function<List<T>, U> finisher;
        private final BiConsumer<List<List<T>>, T> accumulator;

        public ListPartitioner(Function<List<T>, U> finisher, BiConsumer<List<List<T>>, T> accumulator) {
            this.finisher = Objects.requireNonNull(finisher);
            this.accumulator = Objects.requireNonNull(accumulator);
        }

        @Override
        public Supplier<List<List<T>>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<List<T>>, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public BinaryOperator<List<List<T>>> combiner() {
            return (r1, r2) -> {
                r1.addAll(r2);
                return r1;
            };
        }

        @Override
        public Function<List<List<T>>, List<U>> finisher() {
            return l -> l.stream().map(this.finisher).collect(Collectors.toList());
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT});
        }
    }
}

