/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mitre.caasd.commons.util.PropertyUtils;

@Deprecated
public class QuickProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableMap<String, String> properties;
    private final ImmutableSet<String> requiredProperties;

    public QuickProperties(String pathToTextFile, Collection<String> requiredProps) {
        this(PropertyUtils.loadProperties(pathToTextFile), requiredProps);
    }

    public QuickProperties(File propertiesFile, Collection<String> requiredProps) {
        this(PropertyUtils.loadProperties(propertiesFile), requiredProps);
    }

    public QuickProperties(Properties properties, Collection<String> requiredProps) {
        this((Map<String, String>)PropertyUtils.asImmutableMap(properties), (Collection<String>)((Collection)Preconditions.checkNotNull(requiredProps, (Object)"The requiredProps cannot be null")));
    }

    public QuickProperties(Map<String, String> mapOfProperties, Collection<String> requiredProps) {
        Preconditions.checkNotNull(mapOfProperties, (Object)"The input map cannot be null");
        this.properties = ImmutableMap.copyOf(mapOfProperties);
        this.requiredProperties = ImmutableSet.copyOf(requiredProps);
        this.verifyRequiredPropertiesAreSet();
    }

    private void verifyRequiredPropertiesAreSet() {
        for (String requiredProperty : this.requiredProperties) {
            this.getRequired(requiredProperty);
        }
    }

    protected String getRequired(String propertyName) {
        String value = (String)this.properties.get((Object)propertyName);
        if (value != null) {
            return value.trim();
        }
        throw new PropertyUtils.MissingPropertyException(propertyName);
    }

    private Optional<String> getOptionalProperty(String propertyName) {
        String value = (String)this.properties.get((Object)propertyName);
        if (value != null) {
            return Optional.of(value.trim());
        }
        return Optional.empty();
    }

    protected String getString(String propertyName) {
        return this.getRequired(propertyName);
    }

    protected byte getByte(String propertyName) {
        return Byte.parseByte(this.getRequired(propertyName));
    }

    protected short getShort(String propertyName) {
        return Short.parseShort(this.getRequired(propertyName));
    }

    protected int getInt(String propertyName) {
        return Integer.parseInt(this.getRequired(propertyName));
    }

    protected long getLong(String propertyName) {
        return Long.parseLong(this.getRequired(propertyName));
    }

    protected float getFloat(String propertyName) {
        return Float.parseFloat(this.getRequired(propertyName));
    }

    protected double getDouble(String propertyName) {
        return Double.parseDouble(this.getRequired(propertyName));
    }

    protected boolean getBoolean(String propertyName) {
        return Boolean.parseBoolean(this.getRequired(propertyName));
    }

    protected Optional<String> getOptionalString(String propertyName) {
        return this.getOptionalProperty(propertyName);
    }

    protected Optional<Byte> getOptionalByte(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.isPresent() ? Optional.of(Byte.parseByte(prop.get())) : Optional.empty();
    }

    protected Optional<Short> getOptionalShort(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.isPresent() ? Optional.of(Short.parseShort(prop.get())) : Optional.empty();
    }

    protected Optional<Integer> getOptionalInt(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.isPresent() ? Optional.of(Integer.parseInt(prop.get())) : Optional.empty();
    }

    protected Optional<Long> getOptionalLong(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.isPresent() ? Optional.of(Long.parseLong(prop.get())) : Optional.empty();
    }

    protected Optional<Float> getOptionalFloat(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.isPresent() ? Optional.of(Float.valueOf(Float.parseFloat(prop.get()))) : Optional.empty();
    }

    protected Optional<Double> getOptionalDouble(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.isPresent() ? Optional.of(Double.parseDouble(prop.get())) : Optional.empty();
    }

    protected Optional<Boolean> getOptionalBoolean(String propertyName) {
        Optional<String> prop = this.getOptionalProperty(propertyName);
        return prop.isPresent() ? Optional.of(Boolean.parseBoolean(prop.get())) : Optional.empty();
    }

    public ImmutableSortedSet<Map.Entry<String, String>> entrySet() {
        Comparator comparator = (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey());
        return ImmutableSortedSet.orderedBy((Comparator)comparator).addAll((Iterable)this.properties.entrySet()).build();
    }

    public ImmutableMap<String, String> rawMapping() {
        return this.properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String SPACING = " : ";
        for (Map.Entry entry : this.entrySet()) {
            String propertyName = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(propertyName).append(SPACING).append(value).append("\n");
        }
        return sb.toString();
    }

    public Properties properties() {
        Properties props = new Properties();
        for (Map.Entry entry : this.properties.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }
}

