/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;

public class SingleUseTimer {
    Instant startTime = null;
    Instant endTime = null;

    public void tic() {
        Preconditions.checkState((this.startTime == null ? 1 : 0) != 0, (Object)"This timer was already started");
        this.startTime = Instant.now();
    }

    public void toc() {
        Preconditions.checkState((this.startTime != null ? 1 : 0) != 0, (Object)"Must call tic() before toc()");
        Preconditions.checkState((this.endTime == null ? 1 : 0) != 0, (Object)"This timer was already stopped");
        this.endTime = Instant.now();
    }

    public Duration elapsedTime() {
        Preconditions.checkState((this.startTime != null ? 1 : 0) != 0, (Object)"This timer was never started (must call \"tic\")");
        return this.endTime == null ? Duration.between(this.startTime, Instant.now()) : Duration.between(this.startTime, this.endTime);
    }

    public static void printTimeElapsed(Runnable timeMe) {
        System.out.println("Time elapsed: " + SingleUseTimer.timeJob(timeMe).getSeconds() + " seconds");
    }

    public static Duration timeJob(Runnable timeMe) {
        SingleUseTimer timer = new SingleUseTimer();
        timer.tic();
        timeMe.run();
        timer.toc();
        return timer.elapsedTime();
    }
}

