/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.mitre.caasd.commons.Speed;

public class Acceleration
implements Serializable,
Comparable<Acceleration> {
    private static final long serialVersionUID = 4844288921728246175L;
    public static final Acceleration ZERO = Acceleration.of(Speed.ZERO, Duration.ofSeconds(1L));
    private final Speed speedDeltaPerSecond;

    private Acceleration() {
        this(Speed.ZERO, Duration.ofSeconds(1L));
    }

    public Acceleration(Speed speedDelta, Duration elapsedTime) {
        Objects.requireNonNull(speedDelta);
        Objects.requireNonNull(elapsedTime);
        Preconditions.checkArgument((!elapsedTime.isNegative() ? 1 : 0) != 0);
        Preconditions.checkArgument((!elapsedTime.isZero() ? 1 : 0) != 0);
        double msElapsed = elapsedTime.toMillis();
        double numSeconds = msElapsed / 1000.0;
        this.speedDeltaPerSecond = speedDelta.times(1.0 / numSeconds);
    }

    public Acceleration(Speed speedDeltaPerSecond) {
        this(speedDeltaPerSecond, Duration.ofSeconds(1L));
    }

    @Override
    public int compareTo(Acceleration acceleration) {
        return this.speedDeltaPerSecond.compareTo(acceleration.speedDeltaPerSecond);
    }

    public static Acceleration of(Speed changeInSpeed, Duration elapsedTime) {
        return new Acceleration(changeInSpeed, elapsedTime);
    }

    public static Acceleration of(Speed speedDeltaPerSecond) {
        return new Acceleration(speedDeltaPerSecond);
    }

    public boolean isLessThan(Acceleration other) {
        return this.speedDeltaPerSecond.isLessThan(other.speedDeltaPerSecond);
    }

    public boolean isLessThanOrEqualTo(Acceleration other) {
        return this.speedDeltaPerSecond.isLessThanOrEqualTo(other.speedDeltaPerSecond);
    }

    public boolean isGreaterThan(Acceleration other) {
        return this.speedDeltaPerSecond.isGreaterThan(other.speedDeltaPerSecond);
    }

    public boolean isGreaterThanOrEqualTo(Acceleration other) {
        return this.speedDeltaPerSecond.isGreaterThanOrEqualTo(other.speedDeltaPerSecond);
    }

    public Acceleration times(double scalar) {
        return new Acceleration(this.speedDeltaPerSecond.times(scalar), Duration.ofSeconds(1L));
    }

    public Acceleration abs() {
        return this.isNegative() ? this.times(-1.0) : this;
    }

    public Speed speedDeltaPerSecond() {
        return this.speedDeltaPerSecond;
    }

    public boolean isPositive() {
        return this.speedDeltaPerSecond.isPositive();
    }

    public boolean isNegative() {
        return this.speedDeltaPerSecond.isNegative();
    }

    public boolean isZero() {
        return this.speedDeltaPerSecond.isZero();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Acceleration that = (Acceleration)o;
        return this.speedDeltaPerSecond.equals(that.speedDeltaPerSecond);
    }

    public int hashCode() {
        return this.speedDeltaPerSecond.hashCode();
    }
}

