/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.mitre.caasd.commons.Distance;

public record AltitudePath(int[] altitudesInFeet) {
    public static final int NULL_ALTITUDE = -2147482414;
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();

    public AltitudePath {
        Objects.requireNonNull(altitudesInFeet);
    }

    public static AltitudePath from(List<Distance> altitudes) {
        Objects.requireNonNull(altitudes);
        int[] alts = altitudes.stream().mapToInt(dist -> AltitudePath.asInt(dist)).toArray();
        return new AltitudePath(alts);
    }

    public static AltitudePath from(Distance ... dist) {
        return AltitudePath.from(List.of(dist));
    }

    public static AltitudePath ofNulls(int n) {
        int[] altitudes = new int[n];
        Arrays.fill(altitudes, -2147482414);
        return new AltitudePath(altitudes);
    }

    private static int asInt(Distance dist) {
        return Objects.nonNull(dist) ? (int)dist.inFeet() : -2147482414;
    }

    public static AltitudePath fromBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        Preconditions.checkArgument((bytes.length % 4 == 0 ? 1 : 0) != 0, (Object)"The byte[] must have a multiple of 4 bytes");
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int[] altData = new int[bytes.length / 4];
        for (int i = 0; i < altData.length; ++i) {
            altData[i] = buffer.getInt();
        }
        return new AltitudePath(altData);
    }

    public static AltitudePath fromBase64Str(String base64Encoding) {
        return AltitudePath.fromBytes(Base64.getUrlDecoder().decode(base64Encoding));
    }

    public int size() {
        return this.altitudesInFeet.length;
    }

    public Distance get(int i) {
        return this.altitudesInFeet[i] == -2147482414 ? null : Distance.ofFeet(this.altitudesInFeet[i]);
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size() * 4);
        for (int i = 0; i < this.altitudesInFeet.length; ++i) {
            buffer.putInt(this.altitudesInFeet[i]);
        }
        return buffer.array();
    }

    public String toBase64() {
        return BASE_64_ENCODER.encodeToString(this.toBytes());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.altitudesInFeet);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AltitudePath other = (AltitudePath)obj;
        return Arrays.equals(this.altitudesInFeet, other.altitudesInFeet);
    }

    public static Distance distanceBtw(AltitudePath p1, AltitudePath p2) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        Preconditions.checkArgument((p1.size() == p2.size() ? 1 : 0) != 0, (Object)"Paths must have same size");
        return AltitudePath.distanceBtw(p1, p2, p1.size());
    }

    public static Distance distanceBtw(AltitudePath p1, AltitudePath p2, int n) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((p1.size() >= n ? 1 : 0) != 0, (Object)"Path1 does not have the required length");
        Preconditions.checkArgument((p2.size() >= n ? 1 : 0) != 0, (Object)"Path2 does not have the required length");
        double distanceSum = 0.0;
        for (int i = 0; i < n; ++i) {
            int mine = p1.altitudesInFeet[i] == -2147482414 ? 0 : p1.altitudesInFeet[i];
            int his = p2.altitudesInFeet[i] == -2147482414 ? 0 : p2.altitudesInFeet[i];
            distanceSum += (double)Math.abs(mine - his);
        }
        return Distance.ofFeet(distanceSum);
    }
}

