/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Function;
import org.mitre.caasd.commons.Pair;
import org.mitre.caasd.commons.Triple;

public class CollectionUtils {
    private CollectionUtils() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    public static <T, R extends Comparable<? super R>> int binarySearch(List<? extends T> preSortedList, Function<T, R> sortValueGetter, R searchKey) {
        if (preSortedList instanceof RandomAccess) {
            return CollectionUtils.indexedBinarySearch(preSortedList, sortValueGetter, searchKey);
        }
        return CollectionUtils.iteratorBinarySearch(preSortedList, sortValueGetter, searchKey);
    }

    private static <T, R extends Comparable<? super R>> int indexedBinarySearch(List<? extends T> preSortedList, Function<T, R> sortValueGetter, R searchKey) {
        int low = 0;
        int high = preSortedList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = preSortedList.get(mid);
            int cmp = ((Comparable)sortValueGetter.apply(midVal)).compareTo(searchKey);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static <T, R extends Comparable<? super R>> int iteratorBinarySearch(List<? extends T> preSortedList, Function<T, R> sortValueGetter, R searchKey) {
        int low = 0;
        int high = preSortedList.size() - 1;
        ListIterator<? extends T> i = preSortedList.listIterator();
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = CollectionUtils.get(i, mid);
            int cmp = ((Comparable)sortValueGetter.apply(midVal)).compareTo(searchKey);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static <T> T get(ListIterator<? extends T> i, int index) {
        T obj = null;
        int pos = i.nextIndex();
        if (pos <= index) {
            do {
                obj = i.next();
            } while (pos++ < index);
        } else {
            do {
                obj = i.previous();
            } while (--pos > index);
        }
        return obj;
    }

    public static <A, B> Iterator<Pair<A, B>> zip(Iterable<A> srcA, Iterable<B> srcB) {
        Objects.requireNonNull(srcA);
        Objects.requireNonNull(srcB);
        return new PairIterator<A, B>(srcA.iterator(), srcB.iterator());
    }

    public static <A, B> Iterator<Pair<A, B>> zip(Iterator<A> srcA, Iterator<B> srcB) {
        Objects.requireNonNull(srcA);
        Objects.requireNonNull(srcB);
        return new PairIterator<A, B>(srcA, srcB);
    }

    public static <A, B, C> Iterator<Triple<A, B, C>> zip(Iterable<A> srcA, Iterable<B> srcB, Iterable<C> srcC) {
        Objects.requireNonNull(srcA);
        Objects.requireNonNull(srcB);
        Objects.requireNonNull(srcC);
        return new TripleIterator<A, B, C>(srcA.iterator(), srcB.iterator(), srcC.iterator());
    }

    public static <A, B, C> Iterator<Triple<A, B, C>> zip(Iterator<A> srcA, Iterator<B> srcB, Iterator<C> srcC) {
        Objects.requireNonNull(srcA);
        Objects.requireNonNull(srcB);
        Objects.requireNonNull(srcC);
        return new TripleIterator<A, B, C>(srcA, srcB, srcC);
    }

    public static class PairIterator<A, B>
    implements Iterator<Pair<A, B>> {
        final Iterator<A> iterA;
        final Iterator<B> iterB;
        private Pair<A, B> next;

        public PairIterator(Iterator<A> iterA, Iterator<B> iterB) {
            this.iterA = Objects.requireNonNull(iterA);
            this.iterB = Objects.requireNonNull(iterB);
            this.updateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Pair<A, B> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Pair<A, B> returnMe = this.next;
            this.updateNext();
            return returnMe;
        }

        private void updateNext() {
            this.next = this.iterA.hasNext() && this.iterB.hasNext() ? Pair.of(this.iterA.next(), this.iterB.next()) : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("A PairIterator cannot remove items.");
        }
    }

    public static class TripleIterator<A, B, C>
    implements Iterator<Triple<A, B, C>> {
        final Iterator<A> iterA;
        final Iterator<B> iterB;
        final Iterator<C> iterC;
        private Triple<A, B, C> next;

        public TripleIterator(Iterator<A> iterA, Iterator<B> iterB, Iterator<C> iterC) {
            this.iterA = Objects.requireNonNull(iterA);
            this.iterB = Objects.requireNonNull(iterB);
            this.iterC = Objects.requireNonNull(iterC);
            this.updateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Triple<A, B, C> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Triple<A, B, C> returnMe = this.next;
            this.updateNext();
            return returnMe;
        }

        private void updateNext() {
            this.next = this.iterA.hasNext() && this.iterB.hasNext() && this.iterC.hasNext() ? Triple.of(this.iterA.next(), this.iterB.next(), this.iterC.next()) : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("A TripleIterator cannot remove items.");
        }
    }
}

