/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class CompositeConsumer<T>
implements Consumer<T> {
    final List<Consumer<T>> consumers = new LinkedList<Consumer<T>>();

    public CompositeConsumer(Consumer<T> oneConsumer) {
        this.consumers.add(oneConsumer);
    }

    @SafeVarargs
    public CompositeConsumer(Consumer<T> ... arrayOfConsumers) {
        this.consumers.addAll(Arrays.asList(arrayOfConsumers));
    }

    @Override
    public void accept(T t) {
        for (Consumer<T> consumer : this.consumers) {
            consumer.accept(t);
        }
    }
}

