/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.math3.util.FastMath;
import org.mitre.caasd.commons.Spherical;

public class Course
implements Comparable<Course> {
    public static final Course ZERO = new Course(0.0, Unit.DEGREES);
    public static final Course NORTH = Course.ofDegrees(0.0);
    public static final Course EAST = Course.ofDegrees(90.0);
    public static final Course SOUTH = Course.ofDegrees(180.0);
    public static final Course WEST = Course.ofDegrees(270.0);
    private final double angle;
    private final Unit unit;

    private Course() {
        this(0.0, Unit.DEGREES);
    }

    public Course(double angle, Unit unit) {
        this.angle = angle;
        Preconditions.checkArgument((!Double.isNaN(angle) ? 1 : 0) != 0, (Object)"\"Not a Number\" is not supported");
        this.unit = (Unit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
    }

    public static Course of(double angle, Unit unit) {
        return new Course(angle, unit);
    }

    public static Course ofDegrees(double angle) {
        return Course.of(angle, Unit.DEGREES);
    }

    public static Course ofRadians(double angle) {
        return Course.of(angle, Unit.RADIANS);
    }

    public static Course angleBetween(Course one, Course two) {
        return Course.ofDegrees(Spherical.angleDifference(one.inDegrees(), two.inDegrees()));
    }

    public Unit nativeUnit() {
        return this.unit;
    }

    public double in(Unit desiredUnit) {
        return this.unit == desiredUnit ? this.angle : this.angle * desiredUnit.unitsPerDegree / this.unit.unitsPerDegree;
    }

    public double inDegrees() {
        return this.in(Unit.DEGREES);
    }

    public double inRadians() {
        return this.in(Unit.RADIANS);
    }

    public Course negate() {
        return Course.of(-this.angle, this.unit);
    }

    public Course abs() {
        return Course.of(Math.abs(this.angle), this.unit);
    }

    public boolean isPositive() {
        return this.angle > 0.0;
    }

    public boolean isNegative() {
        return this.angle < 0.0;
    }

    public boolean isZero() {
        return this.angle == 0.0;
    }

    public Course times(double scalar) {
        return Course.of(this.angle * scalar, this.unit);
    }

    public Course plus(Course otherCourse) {
        return Course.of(this.angle + otherCourse.in(this.unit), this.unit);
    }

    public Course minus(Course otherCourse) {
        return this.plus(otherCourse.times(-1.0));
    }

    public boolean isLessThan(Course otherCourse) {
        return this.angle < otherCourse.in(this.unit);
    }

    public boolean isLessThanOrEqualTo(Course otherCourse) {
        return this.angle <= otherCourse.in(this.unit);
    }

    public boolean isGreaterThan(Course otherCourse) {
        return this.angle > otherCourse.in(this.unit);
    }

    public boolean isGreaterThanOrEqualTo(Course otherCourse) {
        return this.angle >= otherCourse.in(this.unit);
    }

    public double dividedBy(Course otherCourse) {
        return this.angle / otherCourse.in(this.unit);
    }

    public double sin() {
        return FastMath.sin((double)this.inRadians());
    }

    public double cos() {
        return FastMath.cos((double)this.inRadians());
    }

    public double tan() {
        return FastMath.tan((double)this.inRadians());
    }

    @Override
    public int compareTo(Course other) {
        return Double.compare(this.angle, other.in(this.unit));
    }

    public String toString() {
        if (this.unit == Unit.RADIANS) {
            return this.toString(5);
        }
        if (this.unit == Unit.DEGREES) {
            return this.toString(0);
        }
        throw new AssertionError((Object)"unhandled unit");
    }

    public String toString(int digitsAfterDecimalPlace) {
        return String.format("%." + digitsAfterDecimalPlace + "f" + this.unit.suffix, this.angle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (int)(Double.doubleToLongBits(this.angle) ^ Double.doubleToLongBits(this.angle) >>> 32);
        hash = 73 * hash + Objects.hashCode((Object)this.unit);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Course other = (Course)obj;
        if (Double.doubleToLongBits(this.angle) != Double.doubleToLongBits(other.angle)) {
            return false;
        }
        return this.unit == other.unit;
    }

    public static enum Unit {
        DEGREES(1.0, "deg"),
        RADIANS(Math.PI / 180, "rad");

        private final double unitsPerDegree;
        private final String suffix;

        private Unit(double unitsPerMeter, String suffix) {
            this.unitsPerDegree = unitsPerMeter;
            this.suffix = suffix;
        }

        public double unitsPerDegree() {
            return this.unitsPerDegree;
        }

        public String abbreviation() {
            return this.suffix;
        }
    }
}

