/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.Speed;

public class Distance
implements Serializable,
Comparable<Distance> {
    public static final Distance ZERO = new Distance(0.0, Unit.NAUTICAL_MILES);
    public static final Distance ZERO_FEET = new Distance(0.0, Unit.FEET);
    private final double amount;
    private final Unit unit;

    private Distance() {
        this(0.0, Unit.NAUTICAL_MILES);
    }

    public Distance(double amount, Unit unit) {
        this.amount = amount;
        Preconditions.checkArgument((!Double.isNaN(amount) ? 1 : 0) != 0, (Object)"Distance values of \"Not a Number\" are not supported");
        this.unit = (Unit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
    }

    public static Distance of(double amount, Unit unit) {
        return new Distance(amount, unit);
    }

    public static Distance ofMeters(double amount) {
        return Distance.of(amount, Unit.METERS);
    }

    public static Distance ofKiloMeters(double amount) {
        return Distance.of(amount, Unit.KILOMETERS);
    }

    public static Distance ofFeet(double amount) {
        return Distance.of(amount, Unit.FEET);
    }

    public static Distance ofMiles(double amount) {
        return Distance.of(amount, Unit.MILES);
    }

    public static Distance ofNauticalMiles(double amount) {
        return Distance.of(amount, Unit.NAUTICAL_MILES);
    }

    public static Distance between(LatLong one, LatLong two) {
        return one.distanceTo(two);
    }

    public Unit nativeUnit() {
        return this.unit;
    }

    public double in(Unit desiredUnit) {
        return this.unit == desiredUnit ? this.amount : this.amount * desiredUnit.unitsPerMeter / this.unit.unitsPerMeter;
    }

    public double inMeters() {
        return this.in(Unit.METERS);
    }

    public double inKilometers() {
        return this.in(Unit.KILOMETERS);
    }

    public double inNauticalMiles() {
        return this.in(Unit.NAUTICAL_MILES);
    }

    public double inFeet() {
        return this.in(Unit.FEET);
    }

    public double inMiles() {
        return this.in(Unit.MILES);
    }

    public Distance negate() {
        return Distance.of(-this.amount, this.unit);
    }

    public Distance abs() {
        return Distance.of(Math.abs(this.amount), this.unit);
    }

    public boolean isPositive() {
        return this.amount > 0.0;
    }

    public boolean isNegative() {
        return this.amount < 0.0;
    }

    public boolean isZero() {
        return this.amount == 0.0;
    }

    public Distance times(double scalar) {
        return Distance.of(this.amount * scalar, this.unit);
    }

    public Distance plus(Distance otherDist) {
        return Distance.of(this.amount + otherDist.in(this.unit), this.unit);
    }

    public Distance minus(Distance otherDist) {
        return this.plus(otherDist.times(-1.0));
    }

    public boolean isLessThan(Distance otherDist) {
        return this.amount < otherDist.in(this.unit);
    }

    public boolean isLessThanOrEqualTo(Distance otherDist) {
        return this.amount <= otherDist.in(this.unit);
    }

    public boolean isGreaterThan(Distance otherDist) {
        return this.amount > otherDist.in(this.unit);
    }

    public boolean isGreaterThanOrEqualTo(Distance otherDist) {
        return this.amount >= otherDist.in(this.unit);
    }

    public double dividedBy(Distance otherDist) {
        return this.amount / otherDist.in(this.unit);
    }

    public Speed dividedBy(Duration lengthOfTime) {
        return new Speed(this, lengthOfTime);
    }

    @Override
    public int compareTo(Distance o) {
        return Double.compare(this.inMeters(), o.inMeters());
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.amount) ^ Double.doubleToLongBits(this.amount) >>> 32);
        hash = 59 * hash + Objects.hashCode((Object)this.unit);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Distance other = (Distance)obj;
        if (Double.doubleToLongBits(this.amount) != Double.doubleToLongBits(other.amount)) {
            return false;
        }
        return this.unit == other.unit;
    }

    public String toString() {
        if (this.unit == Unit.NAUTICAL_MILES || this.unit == Unit.KILOMETERS || this.unit == Unit.MILES) {
            return this.toString(5);
        }
        return this.toString(2);
    }

    public String toString(int digitsAfterDecimalPlace) {
        return String.format("%." + digitsAfterDecimalPlace + "f" + this.unit.abbreviation, this.amount);
    }

    public static Distance fromString(String parseMe) {
        Preconditions.checkNotNull((Object)parseMe);
        parseMe = parseMe.trim();
        Unit unit = Distance.unitFromString(parseMe);
        if (unit == null) {
            throw new IllegalArgumentException("Could not parse Distance Unit from: " + parseMe);
        }
        String parseMeWithoutUnitsSuffix = parseMe.substring(0, parseMe.length() - unit.abbreviation.length());
        double amount = Double.parseDouble(parseMeWithoutUnitsSuffix);
        return Distance.of(amount, unit);
    }

    public static Unit unitFromString(String parseMe) {
        for (Unit unit : Unit.values()) {
            if (!parseMe.endsWith(unit.abbreviation)) continue;
            return unit;
        }
        return null;
    }

    public static Distance mean(Distance ... distances) {
        return Distance.mean(Arrays.asList(distances));
    }

    public static Distance mean(Iterable<Distance> distances) {
        Preconditions.checkNotNull(distances);
        Preconditions.checkArgument((boolean)distances.iterator().hasNext(), (Object)"Collection of Distances cannot be empty");
        EnumMultiset unitCounts = EnumMultiset.create(Unit.class);
        double sum = 0.0;
        for (Distance distance : distances) {
            sum += distance.inMeters();
            unitCounts.add((Object)distance.unit);
        }
        double averageInMeters = sum / (double)unitCounts.size();
        Distance avg = Distance.ofMeters(averageInMeters);
        Unit unit = Distance.mostCommonUnit((EnumMultiset<Unit>)unitCounts);
        return Distance.of(avg.in(unit), unit);
    }

    public static Distance sum(Distance ... distances) {
        return Distance.sum(Arrays.asList(distances));
    }

    public static Distance sum(Iterable<Distance> distances) {
        Preconditions.checkNotNull(distances);
        if (!distances.iterator().hasNext()) {
            return Distance.ofMeters(0.0);
        }
        EnumMultiset unitCounts = EnumMultiset.create(Unit.class);
        double sumInMeters = 0.0;
        for (Distance distance : distances) {
            sumInMeters += distance.inMeters();
            unitCounts.add((Object)distance.unit);
        }
        Distance avg = Distance.ofMeters(sumInMeters);
        Unit unit = Distance.mostCommonUnit((EnumMultiset<Unit>)unitCounts);
        return Distance.of(avg.in(unit), unit);
    }

    public static Distance min(Distance ... distances) {
        Preconditions.checkNotNull((Object)distances);
        return Distance.min((Iterator<Distance>)Iterators.forArray((Object[])distances));
    }

    public static Distance min(Iterable<Distance> distances) {
        Preconditions.checkNotNull(distances);
        return Distance.min(distances.iterator());
    }

    public static Distance min(Iterator<Distance> distances) {
        Preconditions.checkNotNull(distances);
        if (!distances.hasNext()) {
            return null;
        }
        Distance currentMin = null;
        while (distances.hasNext()) {
            if (currentMin == null) {
                currentMin = distances.next();
                continue;
            }
            currentMin = Distance.min(currentMin, distances.next());
        }
        return currentMin;
    }

    public static Distance min(Distance one, Distance two) {
        Preconditions.checkNotNull((Object)one);
        Preconditions.checkNotNull((Object)two);
        return one.isLessThanOrEqualTo(two) ? one : two;
    }

    public static Distance max(Distance ... distances) {
        Preconditions.checkNotNull((Object)distances);
        return Distance.max((Iterator<Distance>)Iterators.forArray((Object[])distances));
    }

    public static Distance max(Iterable<Distance> distances) {
        Preconditions.checkNotNull(distances);
        return Distance.max(distances.iterator());
    }

    public static Distance max(Iterator<Distance> distances) {
        Preconditions.checkNotNull(distances);
        if (!distances.hasNext()) {
            return null;
        }
        Distance currentMax = null;
        while (distances.hasNext()) {
            if (currentMax == null) {
                currentMax = distances.next();
                continue;
            }
            currentMax = Distance.max(currentMax, distances.next());
        }
        return currentMax;
    }

    public static Distance max(Distance one, Distance two) {
        Preconditions.checkNotNull((Object)one);
        Preconditions.checkNotNull((Object)two);
        return one.isGreaterThanOrEqualTo(two) ? one : two;
    }

    private static Unit mostCommonUnit(EnumMultiset<Unit> unitCounts) {
        return (Unit)((Object)((Multiset.Entry)unitCounts.entrySet().stream().sorted((e1, e2) -> Integer.compare(e2.getCount(), e1.getCount())).findFirst().get()).getElement());
    }

    public static enum Unit {
        KILOMETERS(0.001, "km"),
        METERS(1.0, "m"),
        FEET(3.280839895013123, "ft"),
        MILES(6.213711922373339E-4, "mi"),
        NAUTICAL_MILES(5.399568034557236E-4, "NM");

        private final double unitsPerMeter;
        private final String abbreviation;

        private Unit(double unitsPerMeter, String suffix) {
            this.unitsPerMeter = unitsPerMeter;
            this.abbreviation = suffix;
        }

        public double unitsPerMeter() {
            return this.unitsPerMeter;
        }

        public String abbreviation() {
            return this.abbreviation;
        }
    }
}

