/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class FilteredConsumer<T>
implements Consumer<T>,
Serializable {
    private static final long serialVersionUID = 7232976316826633043L;
    private final Predicate<T> filter;
    private final Consumer<T> whenTrue;
    private final Consumer<T> whenFalse;

    public FilteredConsumer(Predicate<T> filter, Consumer<T> whenTrue) {
        this(filter, whenTrue, inputItem -> {});
    }

    public FilteredConsumer(Predicate<T> filter, Consumer<T> whenTrue, Consumer<T> whenFalse) {
        Objects.requireNonNull(filter);
        Objects.requireNonNull(whenTrue);
        Objects.requireNonNull(whenFalse);
        this.filter = filter;
        this.whenTrue = whenTrue;
        this.whenFalse = whenFalse;
    }

    @Override
    public void accept(T item) {
        if (this.filter.test(item)) {
            this.whenTrue.accept(item);
        } else {
            this.whenFalse.accept(item);
        }
    }

    public Predicate<T> filter() {
        return this.filter;
    }

    public Consumer<T> whenTrue() {
        return this.whenTrue;
    }

    public Consumer<T> whenFalse() {
        return this.whenFalse;
    }
}

