/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Interval
implements Serializable,
Comparable<Interval> {
    public static final Long SECOND = 1000L;
    public static final Long MINUTE = SECOND * 60L;
    public static final Long HOUR = MINUTE * 60L;
    public static final Long DAY = HOUR * 24L;
    public static final Long WEEK = DAY * 7L;
    public static final Long YEAR = DAY * 365L;
    private final Long start_time;
    private final Long end_time;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_DATE.withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC);

    @Deprecated
    public Interval() {
        this.start_time = null;
        this.end_time = null;
    }

    public Interval(Instant start, Instant end) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        this.start_time = start.equals(Instant.MIN) ? Long.MIN_VALUE : start.toEpochMilli();
        this.end_time = end.equals(Instant.MAX) ? Long.MAX_VALUE : end.toEpochMilli();
        Preconditions.checkArgument((this.start_time <= this.end_time ? 1 : 0) != 0, (Object)"Cannot create Interval with start time after end time");
    }

    public Interval(OffsetDateTime start, OffsetDateTime end) {
        this(start.toInstant(), end.toInstant());
    }

    public Interval(LocalDate startDateInclusive, LocalDate endDateInclusive) {
        this(startDateInclusive.equals(LocalDate.MIN) ? Instant.MIN : startDateInclusive.atStartOfDay().toInstant(ZoneOffset.UTC), endDateInclusive.equals(LocalDate.MAX) ? Instant.MAX : endDateInclusive.plus(1L, ChronoUnit.DAYS).atStartOfDay().toInstant(ZoneOffset.UTC));
    }

    public boolean isEmpty() {
        return !this.start().isBefore(this.end());
    }

    public Long startEpoch() {
        return this.start_time;
    }

    public Long endEpoch() {
        return this.end_time;
    }

    public Instant start() {
        return this.startEpoch().equals(Long.MIN_VALUE) ? Instant.MIN : Instant.ofEpochMilli(this.startEpoch());
    }

    public Instant end() {
        return this.endEpoch().equals(Long.MAX_VALUE) ? Instant.MAX : Instant.ofEpochMilli(this.endEpoch());
    }

    public Instant getStartDay() {
        return this.start().truncatedTo(ChronoUnit.DAYS);
    }

    public Instant getEndDay() {
        return this.end().truncatedTo(ChronoUnit.DAYS);
    }

    public Long getMidpointEpoch() {
        return (this.start_time + this.end_time) / 2L;
    }

    public Duration duration() {
        return Duration.between(this.start(), this.end());
    }

    public boolean contains(Long time) {
        return this.start_time <= time && this.end_time > time;
    }

    public boolean contains(Instant time) {
        return this.contains(time.toEpochMilli());
    }

    public boolean contains(Interval i) {
        return this.start_time <= i.startEpoch() && this.end_time >= i.endEpoch();
    }

    public boolean contains(LocalDate dt) {
        return this.contains(new Interval(dt, dt));
    }

    public boolean containsClosed(Instant tau) {
        return this.contains(tau) || this.end().equals(tau);
    }

    public boolean overlaps(Interval i) {
        return this.start().isBefore(i.end()) && this.end().isAfter(i.start());
    }

    public boolean overlaps(LocalDate dt) {
        return this.overlaps(new Interval(dt, dt));
    }

    public Interval withBuffer(Integer daysBefore, Integer daysAfter) {
        if (daysBefore != null && daysAfter != null) {
            return new Interval(this.start().plus((long)daysBefore.intValue(), ChronoUnit.DAYS), this.end().plus((long)daysAfter.intValue(), ChronoUnit.DAYS));
        }
        return this;
    }

    public Interval shiftForward(Duration d) {
        return new Interval(this.start().plus(d), this.end().plus(d));
    }

    public Interval shiftBackward(Duration d) {
        return new Interval(this.start().minus(d), this.end().minus(d));
    }

    public Interval extend(Interval i) {
        return this.extend(i.start(), i.end());
    }

    public Interval extend(Instant s, Instant e) {
        if (this.isEmpty() && s != null && e != null) {
            return new Interval(s, e);
        }
        if (s != null && s.equals(e)) {
            return new Interval(this.start(), this.end());
        }
        Instant start = s == null || s.isAfter(this.start()) ? this.start() : s;
        Instant end = e == null || e.isBefore(this.end()) ? this.end() : e;
        return new Interval(start, end);
    }

    public Interval extendBy(Duration d) {
        return new Interval(this.start(), this.end().plus(d));
    }

    public Interval extendTo(Instant time) {
        return new Interval(this.start(), time.isAfter(this.end()) ? time : this.end());
    }

    public Interval truncateTo(Interval int1) {
        Instant end;
        Instant start = this.start().isBefore(int1.start()) ? int1.start() : this.start();
        Instant instant = end = this.end().isAfter(int1.end()) ? int1.end() : this.end();
        if (start.isAfter(end)) {
            start = end;
        }
        return new Interval(start, end);
    }

    public List<LocalDate> listDates() {
        return Interval.datesBetween(this.start(), this.end()).map(i -> i.atZone(ZoneId.of("GMT")).toLocalDate()).collect(Collectors.toList());
    }

    public Stream<Instant> timesBetween(Duration width) {
        return Interval.timesBetween(this.start(), this.end(), width);
    }

    public <P extends Comparable<? super P>> NavigableSet<P> filter(NavigableSet<P> vals, Function<P, Instant> conv) {
        return vals.stream().filter(val -> this.contains((Instant)conv.apply(val))).collect(Collectors.toCollection(TreeSet::new));
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.start_time);
        hash = 17 * hash + Objects.hashCode(this.end_time);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (!Objects.equals(this.start_time, other.start_time)) {
            return false;
        }
        return Objects.equals(this.end_time, other.end_time);
    }

    @Override
    public int compareTo(Interval o) {
        int comp = this.start_time.compareTo(o.startEpoch());
        return comp != 0 ? comp : this.end_time.compareTo(o.endEpoch());
    }

    public static Long seconds(int num) {
        return SECOND * (long)num;
    }

    public static Interval covering(Collection<LocalDate> dates) {
        Objects.requireNonNull(dates);
        Preconditions.checkArgument((!dates.isEmpty() ? 1 : 0) != 0, (Object)"No covering for an empty date set.");
        return new Interval(dates.stream().min(LocalDate::compareTo).get(), dates.stream().max(LocalDate::compareTo).get());
    }

    public static Interval covering(LocalDate ... dates) {
        return Interval.covering(Arrays.asList(dates));
    }

    public static Interval parseInstants(String start, String end) {
        return new Interval(Instant.parse(start), Instant.parse(end));
    }

    public static Interval parseLocalDates(String startInclusive, String endInclusive) {
        return new Interval(LocalDate.parse(startInclusive), LocalDate.parse(endInclusive));
    }

    public static Collection<Interval> fromRange(Long startTOD, Long endTOD, List<Integer> daysOfWeek, Long startDate, Long endDate) {
        HashSet<Interval> itvs = new HashSet<Interval>();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        long startDay = startDate - startDate % DAY;
        long endDay = endDate + (DAY - endDate % DAY);
        for (long day = startDay; day < endDay; day += DAY.longValue()) {
            c.setTime(Date.from(Instant.ofEpochMilli(day)));
            if (!daysOfWeek.contains(c.get(7))) continue;
            Interval itrvl = new Interval(Instant.ofEpochMilli(day + startTOD), Instant.ofEpochMilli(day + endTOD));
            itvs.add(itrvl);
        }
        return itvs;
    }

    public static Stream<Instant> datesBetween(Instant start, Instant end) {
        return Interval.timesBetween(start, end, Duration.ofMillis(DAY));
    }

    public static Stream<Instant> timesBetween(Instant start, Instant end, Duration width) {
        if ((end.toEpochMilli() - start.toEpochMilli()) / width.toMillis() > 99999L) {
            throw new IllegalArgumentException("Too many sub-intervals to enumerate");
        }
        ArrayList times = Lists.newArrayList();
        long startTime = start.toEpochMilli() - start.toEpochMilli() % width.toMillis();
        long endTime = end.toEpochMilli();
        long step = width.toMillis();
        for (long time = startTime; time < endTime; time += step) {
            if (time < start.toEpochMilli()) continue;
            times.add(Instant.ofEpochMilli(time));
        }
        return times.stream();
    }

    public static boolean areDisjoint(Collection<Interval> intervals) {
        List itvs = intervals.stream().sorted().collect(Collectors.toList());
        return IntStream.range(1, itvs.size()).filter(i -> ((Interval)itvs.get(i - 1)).overlaps((Interval)itvs.get(i))).count() == 0L;
    }

    public static Collection<Interval> complementOf(Interval full, Collection<Interval> subintervals) {
        if (!Interval.areDisjoint(subintervals)) {
            throw new RuntimeException("Taking the complement of a collection of overlapping intervals is currently unsupported. Intervals were: " + subintervals.stream().map(Object::toString).collect(Collectors.joining("\n")));
        }
        NavigableSet times = subintervals.stream().flatMap(i -> Stream.of(i.start(), i.end())).collect(Collectors.toCollection(TreeSet::new));
        times.add(full.start());
        times.add(full.end());
        ArrayList dts = new ArrayList(times);
        NavigableSet fullCover = IntStream.range(1, dts.size()).mapToObj(i -> new Interval((Instant)dts.get(i - 1), (Instant)dts.get(i))).collect(Collectors.toCollection(TreeSet::new));
        return new HashSet<Interval>((Collection<Interval>)Sets.difference((Set)fullCover, new TreeSet<Interval>(subintervals)));
    }

    public static NavigableSet<Interval> merge(Collection<Interval> itvs) {
        List sorted = itvs.stream().sorted().collect(Collectors.toList());
        TreeSet<Interval> merged = new TreeSet<Interval>();
        Interval open = (Interval)sorted.get(0);
        for (int i = 1; i < sorted.size(); ++i) {
            Interval current = (Interval)sorted.get(i);
            if (open.end().equals(current.start()) || open.overlaps(current)) {
                open = open.extend(current);
                continue;
            }
            merged.add(open);
            open = current;
        }
        merged.add(open);
        return merged;
    }

    public static Interval empty() {
        return new Interval(Instant.EPOCH, Instant.EPOCH);
    }

    public static Interval max() {
        return new Interval(Instant.MIN, Instant.MAX);
    }

    public String toString() {
        return this.start_time.toString() + " " + this.end_time.toString();
    }

    public String toString(boolean printInstants) {
        return printInstants ? String.valueOf(this.start()) + " - " + String.valueOf(this.end()) : this.toString();
    }

    public String toSimpleString() {
        String start = DATE_TIME_FORMAT.format(this.start());
        String end = DATE_TIME_FORMAT.format(this.end());
        if (this.start().equals(this.getStartDay()) && this.end().equals(this.getEndDay())) {
            start = DATE_FORMAT.format(this.start().atOffset(ZoneOffset.UTC).toLocalDate());
            end = DATE_FORMAT.format(this.end().atOffset(ZoneOffset.UTC).toLocalDate());
            if (this.duration().toDays() == 1L) {
                end = null;
            }
        }
        return Stream.of(start, end).filter(Objects::nonNull).collect(Collectors.joining(" - "));
    }
}

