/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Objects;
import org.mitre.caasd.commons.LatLong;

public class LatLong64
implements Comparable<LatLong64> {
    private final int latitudeAsInt;
    private final int longitudeAsInt;

    static int encodeAsInt(double latOrLong) {
        double shifted = latOrLong * 1.0E7;
        return (int)Math.round(shifted);
    }

    static double decodeInt(int latOrLongAsInt) {
        return (double)latOrLongAsInt / 1.0E7;
    }

    LatLong64(Double latitude, Double longitude) {
        this(LatLong.of(latitude, longitude));
    }

    LatLong64(LatLong location) {
        this(LatLong64.encodeAsInt(location.latitude()), LatLong64.encodeAsInt(location.longitude()));
    }

    private LatLong64(int encodedLatitude, int encodedLongitude) {
        Preconditions.checkArgument((-900000000 <= encodedLatitude && encodedLatitude <= 900000000 ? 1 : 0) != 0);
        Preconditions.checkArgument((-1800000000 <= encodedLongitude && encodedLongitude <= 1800000000 ? 1 : 0) != 0);
        this.latitudeAsInt = encodedLatitude;
        this.longitudeAsInt = encodedLongitude;
    }

    public static LatLong64 fromLatLong(LatLong loc) {
        return new LatLong64(loc.latitude(), loc.longitude());
    }

    public static LatLong64 fromPrimitiveLong(long latLong64Bits) {
        int lngBits = (int)latLong64Bits;
        int latBits = (int)(latLong64Bits >> 32);
        return new LatLong64(latBits, lngBits);
    }

    public static LatLong64 fromBytes(byte[] exactly8Bytes) {
        Objects.requireNonNull(exactly8Bytes);
        Preconditions.checkArgument((exactly8Bytes.length == 8 ? 1 : 0) != 0, (Object)"Must use exactly 8 bytes");
        ByteBuffer buffer = ByteBuffer.wrap(exactly8Bytes);
        int latitudeAsInt = buffer.getInt();
        int longitudeAsInt = buffer.getInt();
        return new LatLong64(latitudeAsInt, longitudeAsInt);
    }

    public static LatLong64 fromBase64Str(String base64Encoding) {
        return LatLong64.fromBytes(Base64.getUrlDecoder().decode(base64Encoding));
    }

    public LatLong inflate() {
        return LatLong.of(this.latitude(), this.longitude());
    }

    public double latitude() {
        return LatLong64.decodeInt(this.latitudeAsInt);
    }

    public double longitude() {
        return LatLong64.decodeInt(this.longitudeAsInt);
    }

    public String toString() {
        return "(" + String.format("%.7f", this.latitude()) + "," + String.format("%.7f", this.longitude()) + ")";
    }

    public long toPrimitiveLong() {
        return LatLong64.pack(this.latitudeAsInt, this.longitudeAsInt);
    }

    static long pack(int upperInt, int lowerInt) {
        long upperBits = (long)upperInt << 32;
        long lowerBits = (long)lowerInt & 0xFFFFFFFFL;
        return upperBits | lowerBits;
    }

    public byte[] toBytes() {
        return ByteBuffer.allocate(8).putLong(this.toPrimitiveLong()).array();
    }

    public String toBase64() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.toBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLong64 latLong64 = (LatLong64)o;
        if (this.latitudeAsInt != latLong64.latitudeAsInt) {
            return false;
        }
        return this.longitudeAsInt == latLong64.longitudeAsInt;
    }

    public int hashCode() {
        int result = this.latitudeAsInt;
        result = 31 * result + this.longitudeAsInt;
        return result;
    }

    @Override
    public int compareTo(LatLong64 other) {
        return ComparisonChain.start().compare(this.latitudeAsInt, other.latitudeAsInt).compare(this.longitudeAsInt, other.longitudeAsInt).result();
    }
}

