/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.mitre.caasd.commons.VehiclePath;

public record PathPair(VehiclePath path0, VehiclePath path1) {
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();

    public PathPair {
        Objects.requireNonNull(path0);
        Objects.requireNonNull(path1);
        Preconditions.checkArgument((path0.size() == path1.size() ? 1 : 0) != 0);
    }

    public static PathPair fromBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        int n = bytes.length / 2;
        byte[] frontHalf = Arrays.copyOfRange(bytes, 0, n);
        byte[] backHalf = Arrays.copyOfRange(bytes, n, 2 * n);
        VehiclePath path0 = VehiclePath.fromBytes(frontHalf);
        VehiclePath path1 = VehiclePath.fromBytes(backHalf);
        return new PathPair(path0, path1);
    }

    public static PathPair fromBase64Str(String base64Encoding) {
        return PathPair.fromBytes(Base64.getUrlDecoder().decode(base64Encoding));
    }

    public int size() {
        return this.path0.size();
    }

    public byte[] toBytes() {
        byte[] p1Bytes;
        byte[] p0Bytes = this.path0().toBytes();
        Preconditions.checkState((p0Bytes.length == (p1Bytes = this.path1().toBytes()).length ? 1 : 0) != 0, (Object)"byte count mismatch");
        ByteBuffer buffer = ByteBuffer.allocate(p0Bytes.length + p1Bytes.length);
        buffer.put(p0Bytes);
        buffer.put(p1Bytes);
        return buffer.array();
    }

    public String toBase64() {
        return BASE_64_ENCODER.encodeToString(this.toBytes());
    }

    public static double distanceBtw(PathPair a, PathPair b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Preconditions.checkArgument((a.size() == b.size() ? 1 : 0) != 0, (Object)"Paths must have same size");
        return PathPair.distanceBtw(a, b, a.size());
    }

    public static double distanceBtw(PathPair a, PathPair b, int n) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((a.size() >= n ? 1 : 0) != 0, (Object)"PathPair1 does not have the required length");
        Preconditions.checkArgument((b.size() >= n ? 1 : 0) != 0, (Object)"PathPair2 does not have the required length");
        double opt1 = VehiclePath.distanceBtw(a.path0, b.path0, n) + VehiclePath.distanceBtw(a.path1, b.path1);
        double opt2 = VehiclePath.distanceBtw(a.path0, b.path1, n) + VehiclePath.distanceBtw(a.path1, b.path0);
        return Math.min(opt1, opt2);
    }
}

