/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.LatLongPath;
import org.mitre.caasd.commons.Spherical;

@Deprecated
public class PathSimilarity {
    public static double slowSimilarity(LatLongPath p1, LatLongPath p2) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        Preconditions.checkArgument((p1.size() == p2.size() ? 1 : 0) != 0, (Object)"Paths must have same size");
        double distanceSum = 0.0;
        int n = p1.size();
        for (int i = 0; i < n; ++i) {
            LatLong mine = p1.get(i);
            LatLong his = p2.get(i);
            distanceSum += mine.distanceInNM(his);
        }
        return 0.0 - distanceSum;
    }

    public static double similarity(LatLongPath p1, LatLongPath p2) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        Preconditions.checkArgument((p1.size() == p2.size() ? 1 : 0) != 0);
        double sumOfLatitudeDeltas = PathSimilarity.latitudeDist(p1.latitudes(), p2.latitudes());
        double sumOfLongitudeDeltas = PathSimilarity.longitudeDist(p1.longitudes(), p2.longitudes());
        return -sumOfLatitudeDeltas - sumOfLongitudeDeltas;
    }

    static double latitudeDist(double[] lats1, double[] lats2) {
        double totalDelta = 0.0;
        for (int i = 0; i < lats1.length; ++i) {
            totalDelta += PathSimilarity.latitudeDelta(lats1[i], lats2[i]);
        }
        return totalDelta;
    }

    static double longitudeDist(double[] longs1, double[] longs2) {
        double totalDelta = 0.0;
        int n = longs1.length;
        for (int i = 0; i < n; ++i) {
            totalDelta += PathSimilarity.longitudeDelta(longs1[i], longs2[i]);
        }
        return totalDelta;
    }

    static double latitudeDelta(double latitude1, double latitude2) {
        return Math.abs(latitude1 - latitude2);
    }

    static double longitudeDelta(double longitude1, double longitude2) {
        return Math.abs(Spherical.angleDifference(longitude1 - longitude2));
    }
}

