/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import org.apache.commons.math3.util.FastMath;
import org.mitre.caasd.commons.Course;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.HasPosition;
import org.mitre.caasd.commons.LatLong;

public class Spherical {
    public static final Double EARTH_RADIUS_NM = 3438.14021579022;
    public static final Double METERS_PER_NM = 1852.0;
    public static final Double METERS_PER_FOOT = 0.3048;
    private static final Double TOLERANCE = 1.0E-10;
    private static final Range<Double> NUMERICALLY_TOLERANT_RANGE = Range.closed((Comparable)Double.valueOf(-1.0 - TOLERANCE), (Comparable)Double.valueOf(1.0 + TOLERANCE));

    public static Double oneQuarterCircumferenceOfEarthInNM() {
        return EARTH_RADIUS_NM * Math.PI / 2.0;
    }

    public static Double feetPerNM() {
        return METERS_PER_NM / METERS_PER_FOOT;
    }

    public static Double distanceInNM(Double latDeg1, Double lonDeg1, Double latDeg2, Double lonDeg2) {
        double lat1 = Math.toRadians(latDeg1);
        double lon1 = Math.toRadians(lonDeg1);
        double lat2 = Math.toRadians(latDeg2);
        double lon2 = Math.toRadians(lonDeg2);
        return EARTH_RADIUS_NM * Spherical.ahaversine(Spherical.haversine(lat2 - lat1) + FastMath.cos((double)lat1) * FastMath.cos((double)lat2) * Spherical.haversine(lon2 - lon1));
    }

    public static Distance distanceBtw(LatLong one, LatLong two) {
        return Distance.ofNauticalMiles(Spherical.distanceInNM(one.latitude(), one.longitude(), two.latitude(), two.longitude()));
    }

    public static Distance distanceBtw(HasPosition hp1, HasPosition hp2) {
        return Spherical.distanceBtw(hp1.latLong(), hp2.latLong());
    }

    public static Double courseInDegrees(Double startLat, Double startLong, Double endLat, Double endLong) {
        double lat1 = Math.toRadians(startLat);
        double lon1 = Math.toRadians(startLong);
        double lat2 = Math.toRadians(endLat);
        double lon2 = Math.toRadians(endLong);
        double y = FastMath.sin((double)(lon1 - lon2)) * FastMath.cos((double)lat2);
        double x = FastMath.cos((double)lat1) * FastMath.sin((double)lat2) - FastMath.sin((double)lat1) * FastMath.cos((double)lat2) * FastMath.cos((double)(lon2 - lon1));
        double crs = Math.PI * 2 - Spherical.mod(FastMath.atan2((double)y, (double)x), Math.PI * 2);
        return FastMath.toDegrees((double)crs);
    }

    public static Course courseBtw(Double startLat, Double startLong, Double endLat, Double endLong) {
        return Course.ofDegrees(Spherical.courseInDegrees(startLat, startLong, endLat, endLong));
    }

    public static Course courseBtw(LatLong start, LatLong end) {
        return Spherical.courseBtw(start.latitude(), start.longitude(), end.latitude(), end.longitude());
    }

    public static Course courseBtw(HasPosition start, HasPosition end) {
        return Spherical.courseBtw(start.latLong(), end.latLong());
    }

    public static LatLong projectOut(Double latDeg, Double lonDeg, Double headingDegree, Double distNM) {
        Preconditions.checkArgument((!Double.isNaN(headingDegree) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Double.isNaN(distNM) ? 1 : 0) != 0);
        double lat = Math.toRadians(latDeg);
        double lon = Math.toRadians(lonDeg);
        double crs = Math.toRadians(distNM < 0.0 ? Spherical.mod(headingDegree + 180.0, 360.0) : headingDegree);
        double dist = Math.abs(distNM) / EARTH_RADIUS_NM;
        double latProj = Spherical.asinReal(FastMath.cos((double)dist) * FastMath.sin((double)lat) + FastMath.sin((double)dist) * FastMath.cos((double)lat) * FastMath.cos((double)crs));
        double dlon = Spherical.acosReal((FastMath.cos((double)dist) - FastMath.sin((double)latProj) * FastMath.sin((double)lat)) / (FastMath.cos((double)latProj) * FastMath.cos((double)lat)));
        double lonProj = EARTH_RADIUS_NM * Math.abs(FastMath.cos((double)latProj)) < 0.01 ? lon : (Math.abs(dlon) < 0.7853981633974483 ? lon + FastMath.asin((double)(FastMath.sin((double)dist) * FastMath.sin((double)crs) / FastMath.cos((double)latProj))) : lon + (crs < Math.PI ? 1.0 : -1.0) * dlon);
        latProj = FastMath.toDegrees((double)latProj);
        lonProj = Spherical.mod(FastMath.toDegrees((double)lonProj) + 180.0, 360.0) - 180.0;
        return new LatLong(latProj, lonProj);
    }

    public static LatLong projectOut(LatLong start, Course direction, Distance distance) {
        return Spherical.projectOut(start.latitude(), start.longitude(), direction.inDegrees(), (Double)distance.inNauticalMiles());
    }

    public static LatLong projectOut(LatLong start, Course direction, Distance distance, double curvature) {
        return Spherical.projectOut(start.latitude(), start.longitude(), direction.inDegrees(), distance.inNauticalMiles(), curvature);
    }

    public static LatLong projectOut(Double latDeg, Double lonDeg, double headingDegree, double distNM, double curvature) {
        double rMax = EARTH_RADIUS_NM * Math.PI / 2.0;
        double radiusNM = Math.max(-rMax, Math.min(rMax, 1.0 / curvature));
        LatLong pair = Spherical.projectOut(latDeg, lonDeg, Spherical.mod(headingDegree + 90.0, 360.0), (Double)radiusNM);
        double latCen = pair.latitude();
        double lonCen = pair.longitude();
        double crsDelta = Math.copySign(Math.toDegrees(distNM / (EARTH_RADIUS_NM * Math.sin(Math.min(1.5707963267948966, Math.abs(radiusNM) / EARTH_RADIUS_NM)))), radiusNM);
        double crsCen = Spherical.mod(Spherical.courseInDegrees(latCen, lonCen, latDeg, lonDeg) + crsDelta, 360.0);
        return Spherical.projectOut(latCen, lonCen, crsCen, (Double)Math.abs(radiusNM));
    }

    public static LatLong greatCircleOrigin(Double latitude, Double longitude, Double course) {
        return Spherical.projectOut(latitude, longitude, Spherical.mod(course + 90.0, 360.0), Spherical.oneQuarterCircumferenceOfEarthInNM());
    }

    public static Double curvatureFromPointToPoint(Double latDeg1, Double lonDeg1, Double hdg1, Double latDeg2, Double lonDeg2) {
        double d = Spherical.distanceInNM(latDeg1, lonDeg1, latDeg2, lonDeg2) / EARTH_RADIUS_NM;
        double dTheta = Spherical.angleDifference(Spherical.courseInDegrees(latDeg1, lonDeg1, latDeg2, lonDeg2), hdg1);
        double phi = Math.toRadians(Math.abs(dTheta));
        return 1.0 / Math.copySign(FastMath.atan((double)((1.0 - FastMath.cos((double)d)) / (FastMath.sin((double)d) * FastMath.sin((double)phi)))) * EARTH_RADIUS_NM, dTheta);
    }

    public static Double arcLength(Double radius, Double degrees) {
        return Math.toRadians(degrees) * EARTH_RADIUS_NM * FastMath.sin((double)(radius / EARTH_RADIUS_NM));
    }

    private static double haversine(double x) {
        return (1.0 - FastMath.cos((double)x)) / 2.0;
    }

    private static double ahaversine(double x) {
        return 2.0 * FastMath.asin((double)FastMath.sqrt((double)x));
    }

    public static double mod(double x, double y) {
        double z = x % y;
        if (z < 0.0) {
            z += y;
        }
        return z;
    }

    private static double asinReal(double x) {
        return FastMath.asin((double)Double.max(-1.0, Double.min(1.0, x)));
    }

    private static double acosReal(double x) {
        return FastMath.acos((double)Double.max(-1.0, Double.min(1.0, x)));
    }

    public static Double distanceInNM(LatLong pt1, LatLong pt2) {
        return Spherical.distanceInNM(pt1.latitude(), pt1.longitude(), pt2.latitude(), pt2.longitude());
    }

    public static Double courseInDegrees(LatLong pt1, LatLong pt2) {
        return Spherical.courseInDegrees(pt1.latitude(), pt1.longitude(), pt2.latitude(), pt2.longitude());
    }

    public static Double angleDifference(Double hdg, Double hdg0) {
        return Spherical.angleDifference(hdg - hdg0);
    }

    public static Double angleDifference(Double dz) {
        if (dz > 180.0) {
            return dz - 360.0;
        }
        if (dz < -180.0) {
            return dz + 360.0;
        }
        return dz;
    }

    public static double distanceInRadians(double nauticalMiles) {
        return 2.908882086657216E-4 * nauticalMiles;
    }

    public static double distanceInNM(double radians) {
        return 3437.7467707849396 * radians;
    }

    public static double crossTrackDistanceNM(HasPosition startPoint, HasPosition endPoint, HasPosition location) {
        double dist = startPoint.distanceInRadians(location);
        double angle = Math.toRadians(startPoint.courseInDegrees(location)) - Math.toRadians(startPoint.courseInDegrees(endPoint));
        return Spherical.distanceInNM(FastMath.asin((double)(FastMath.sin((double)dist) * FastMath.sin((double)angle))));
    }

    public static double alongTrackDistanceNM(HasPosition startPoint, HasPosition endPoint, HasPosition p, double CTD) {
        double relAng = Spherical.angleDifference(startPoint.courseInDegrees(endPoint), startPoint.courseInDegrees(p));
        double sign = Math.abs(relAng) > 90.0 ? -1.0 : 1.0;
        double cosCTD = FastMath.cos((double)Spherical.distanceInRadians(CTD));
        double cosPTD = FastMath.cos((double)startPoint.distanceInRadians(p));
        double ratio = cosPTD / cosCTD;
        if (!NUMERICALLY_TOLERANT_RANGE.contains((Comparable)Double.valueOf(ratio))) {
            throw new IllegalStateException("Cannot compute acos of: " + ratio);
        }
        ratio = Math.min(Math.max(ratio, -1.0), 1.0);
        return sign * Spherical.distanceInNM(FastMath.acos((double)ratio));
    }

    public static double alongTrackDistanceNM(HasPosition ls, HasPosition le, HasPosition p) {
        double CTD = Spherical.crossTrackDistanceNM(ls, le, p);
        return Spherical.alongTrackDistanceNM(ls, le, p, Math.abs(CTD));
    }
}

