/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.TimeWindow;

public class Time {
    private Time() {
    }

    public static <H extends HasTime> Comparator<H> compareByTime() {
        return (o1, o2) -> o1.time().compareTo(o2.time());
    }

    public static double getDecimalDuration(Duration dt, TemporalUnit unit) {
        return (double)dt.toMillis() / (double)unit.getDuration().toMillis();
    }

    public static Instant averageTime(Instant time1, Instant time2) {
        Preconditions.checkNotNull((Object)time1, (Object)"The first input to Time.averageTime(Instant, Instant) was null");
        Preconditions.checkNotNull((Object)time2, (Object)"The second input to Time.averageTime(Instant, Instant) was null");
        long timeLong1 = time1.toEpochMilli();
        long timeLong2 = time2.toEpochMilli();
        long avgLong = (timeLong1 + timeLong2) / 2L;
        return Instant.ofEpochMilli(avgLong);
    }

    public static void confirmApproximateTimeOrdering(Instant referenceTime, Instant futureTime, Duration maxInputLag) {
        Preconditions.checkNotNull((Object)referenceTime, (Object)"referenceTime cannot be null");
        Preconditions.checkNotNull((Object)futureTime, (Object)"futureTime cannot be null");
        Preconditions.checkArgument((!maxInputLag.isNegative() ? 1 : 0) != 0, (Object)"Negative input lags are prohibitied for clarity");
        Duration timeDelta = Duration.between(referenceTime, futureTime);
        Preconditions.checkArgument((!timeDelta.plus(maxInputLag).isNegative() ? 1 : 0) != 0, (Object)("The futureTime cannot occur \"far\" in the past.\n  referenceTime: " + referenceTime.toEpochMilli() + "\n  futureTime: " + futureTime.toEpochMilli() + "\n  timeDelta: " + timeDelta.toMillis() + " milliseconds\n  maxInputLag: " + maxInputLag.toMillis() + " milliseconds"));
    }

    public static void confirmStrictTimeOrdering(Instant referenceTime, Instant futureTime) {
        Time.confirmApproximateTimeOrdering(referenceTime, futureTime, Duration.ZERO);
    }

    public static void confirmTimeOrdering(Instant[] times) {
        if (times.length < 2) {
            return;
        }
        for (int i = 1; i < times.length; ++i) {
            Instant prior = times[i - 1];
            Instant current = times[i];
            Preconditions.checkArgument((prior.isBefore(current) || prior.equals(current) ? 1 : 0) != 0);
        }
    }

    public static TimeWindow enclosingTimeWindow(Instant ... times) {
        return TimeWindow.of(Time.earliest(times), Time.latest(times));
    }

    public static TimeWindow enclosingTimeWindow(Collection<Instant> times) {
        Objects.requireNonNull(times);
        Preconditions.checkArgument((!times.isEmpty() ? 1 : 0) != 0);
        Instant minTime = Instant.MAX;
        Instant maxTime = Instant.MIN;
        for (Instant time : times) {
            minTime = Time.earliest(minTime, time);
            maxTime = Time.latest(maxTime, time);
        }
        return new TimeWindow(minTime, maxTime);
    }

    public static Duration durationBtw(Instant ... times) {
        return Time.enclosingTimeWindow(times).duration();
    }

    public static String asZTimeString(Instant instant) {
        DateTimeFormatter Z_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS").withZone(ZoneOffset.UTC);
        return Z_TIME_FORMATTER.format(instant);
    }

    public static Instant earliest(Instant time0, Instant time1) {
        return time0.isBefore(time1) ? time0 : time1;
    }

    public static Instant earliest(Instant ... times) {
        Instant earliest = times[0];
        for (int i = 1; i < times.length; ++i) {
            earliest = Time.earliest(earliest, times[i]);
        }
        return earliest;
    }

    public static Instant latest(Instant time0, Instant time1) {
        return time0.isAfter(time1) ? time0 : time1;
    }

    public static Instant latest(Instant ... times) {
        Instant latest = times[0];
        for (int i = 1; i < times.length; ++i) {
            latest = Time.latest(latest, times[i]);
        }
        return latest;
    }

    public static HasTime latest(HasTime h1, HasTime h2) {
        return h1.time().isAfter(h2.time()) ? h1 : h2;
    }

    static <H extends HasTime> NavigableMap<Instant, H> toMap(Collection<H> items) {
        TreeMap map = Maps.newTreeMap();
        items.forEach(item -> map.put(item.time(), item));
        Preconditions.checkArgument((items.size() == map.size() ? 1 : 0) != 0, (Object)"Two items in the input collection had the same time() value");
        return map;
    }

    public static Duration max(Duration duration1, Duration duration2) {
        return Time.theDuration(duration1).isGreaterThanOrEqualTo(duration2) ? duration1 : duration2;
    }

    public static Duration min(Duration duration1, Duration duration2) {
        return Time.theDuration(duration1).isGreaterThanOrEqualTo(duration2) ? duration2 : duration1;
    }

    public static LiterateDuration theDurationBtw(Instant ... times) {
        return new LiterateDuration(Time.durationBtw(times));
    }

    public static LiterateDuration theDuration(Duration duration) {
        Preconditions.checkNotNull((Object)duration);
        return new LiterateDuration(duration);
    }

    public static class LiterateDuration {
        Duration firstDuration;

        private LiterateDuration(Duration dur) {
            this.firstDuration = (Duration)Preconditions.checkNotNull((Object)dur);
        }

        public boolean isLessThan(Duration secondDuration) {
            return this.firstDuration.toMillis() < secondDuration.toMillis();
        }

        public boolean isLessThanOrEqualTo(Duration secondDuration) {
            return this.firstDuration.toMillis() <= secondDuration.toMillis();
        }

        public boolean isGreaterThan(Duration secondDuration) {
            return this.firstDuration.toMillis() > secondDuration.toMillis();
        }

        public boolean isGreaterThanOrEqualTo(Duration secondDuration) {
            return this.firstDuration.toMillis() >= secondDuration.toMillis();
        }
    }
}

