/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.mitre.caasd.commons.AltitudePath;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.LatLong64Path;

public record VehiclePath(LatLong64Path latLongs, AltitudePath altitudes) {
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();

    public VehiclePath {
        Objects.requireNonNull(latLongs);
        Objects.requireNonNull(altitudes);
        Preconditions.checkArgument((latLongs.size() == altitudes.size() ? 1 : 0) != 0);
    }

    public static VehiclePath withoutAltitudes(LatLong64Path latLongs) {
        Objects.requireNonNull(latLongs);
        return new VehiclePath(latLongs, AltitudePath.ofNulls(latLongs.size()));
    }

    public static VehiclePath fromBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        Preconditions.checkArgument((bytes.length % 12 == 0 ? 1 : 0) != 0, (Object)"The byte[] must have a multiple of 12 bytes");
        int n = bytes.length / 12;
        byte[] latLongBytes = Arrays.copyOfRange(bytes, 0, 8 * n);
        byte[] altBytes = Arrays.copyOfRange(bytes, 8 * n, 12 * n);
        return new VehiclePath(LatLong64Path.fromBytes(latLongBytes), AltitudePath.fromBytes(altBytes));
    }

    public static VehiclePath fromBase64Str(String base64Encoding) {
        return VehiclePath.fromBytes(Base64.getUrlDecoder().decode(base64Encoding));
    }

    public int size() {
        return this.latLongs.size();
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size() * 12);
        buffer.put(this.latLongs.toBytes());
        buffer.put(this.altitudes.toBytes());
        return buffer.array();
    }

    public String toBase64() {
        return BASE_64_ENCODER.encodeToString(this.toBytes());
    }

    public static double distanceBtw(VehiclePath a, VehiclePath b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Preconditions.checkArgument((a.size() == b.size() ? 1 : 0) != 0, (Object)"Paths must have same size");
        return VehiclePath.distanceBtw(a, b, a.size());
    }

    public static double distanceBtw(VehiclePath path1, VehiclePath path2, int n) {
        Objects.requireNonNull(path1);
        Objects.requireNonNull(path2);
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((path1.size() >= n ? 1 : 0) != 0, (Object)"Path1 does not have the required length");
        Preconditions.checkArgument((path2.size() >= n ? 1 : 0) != 0, (Object)"Path2 does not have the required length");
        double ld = LatLong64Path.distanceBtw(path1.latLongs, path2.latLongs, n);
        Distance lateralDist = Distance.ofNauticalMiles(ld);
        Distance vertDist = AltitudePath.distanceBtw(path1.altitudes, path2.altitudes, n);
        return lateralDist.plus(vertDist).inFeet();
    }
}

