/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class HashedLinkedSequence<T>
implements Collection<T>,
Set<T> {
    private static final String DUPLICATE_ELEMENT_WARNING = "Cannot add the same element twice";
    private static final String ITEM_NOT_FOUND_WARNING = "Item not found";
    private final HashMap<T, Node<T>> nodes = Maps.newHashMap();
    private Node<T> firstNode = null;
    private Node<T> lastNode = null;
    private int modCount = 0;

    @SafeVarargs
    public static <E> HashedLinkedSequence<E> newHashedLinkedSequence(E ... elements) {
        HashedLinkedSequence<E> list = new HashedLinkedSequence<E>();
        list.addAll(elements);
        return list;
    }

    public static <E> HashedLinkedSequence<E> newHashedLinkedSequence(Iterable<E> iterable) {
        Preconditions.checkNotNull(iterable);
        HashedLinkedSequence list = new HashedLinkedSequence();
        Iterators.addAll(list, iterable.iterator());
        return list;
    }

    public static <E> HashedLinkedSequence<E> newHashedLinkedSequence() {
        return new HashedLinkedSequence();
    }

    @Override
    public boolean add(T item) {
        this.addLast(item);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T element : c) {
            modified |= this.add(element);
        }
        return modified;
    }

    @SafeVarargs
    public final boolean addAll(T ... array) {
        return Collections.addAll(this, array);
    }

    public void addFirst(T item) {
        Preconditions.checkNotNull(item);
        Preconditions.checkArgument((!this.nodes.containsKey(item) ? 1 : 0) != 0, (Object)DUPLICATE_ELEMENT_WARNING);
        Node<T> oldFirst = this.firstNode;
        Node<T> newNode = new Node<T>(null, item, oldFirst);
        this.nodes.put(item, newNode);
        this.firstNode = newNode;
        if (oldFirst == null) {
            this.lastNode = newNode;
        } else {
            oldFirst.previous = newNode;
        }
        ++this.modCount;
    }

    public void addLast(T item) {
        Preconditions.checkNotNull(item);
        Preconditions.checkArgument((!this.nodes.containsKey(item) ? 1 : 0) != 0, (Object)DUPLICATE_ELEMENT_WARNING);
        Node<T> oldLast = this.lastNode;
        Node<T> newNode = new Node<T>(oldLast, item, null);
        this.nodes.put(item, newNode);
        this.lastNode = newNode;
        if (oldLast == null) {
            this.firstNode = newNode;
        } else {
            oldLast.next = newNode;
        }
        ++this.modCount;
    }

    public T getElementBefore(T existingItem) {
        Node<T> node = this.nodes.get(existingItem);
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)ITEM_NOT_FOUND_WARNING);
        if (node.previous == null) {
            throw new NoSuchElementException();
        }
        return node.previous.item;
    }

    public T getElementAfter(T existingItem) {
        Node<T> node = this.nodes.get(existingItem);
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)ITEM_NOT_FOUND_WARNING);
        if (node.next == null) {
            throw new NoSuchElementException();
        }
        return node.next.item;
    }

    public void insertAfter(T newItem, T existingItem) {
        Node<T> anchorNode = this.nodes.get(existingItem);
        Preconditions.checkArgument((anchorNode != null ? 1 : 0) != 0, (Object)ITEM_NOT_FOUND_WARNING);
        Preconditions.checkArgument((!this.nodes.containsKey(newItem) ? 1 : 0) != 0, (Object)DUPLICATE_ELEMENT_WARNING);
        Node<T> newNode = new Node<T>(anchorNode, newItem, anchorNode.next);
        anchorNode.next = newNode;
        if (newNode.next != null) {
            newNode.next.previous = newNode;
        }
        if (anchorNode == this.lastNode) {
            this.lastNode = newNode;
        }
        this.nodes.put(newItem, newNode);
        ++this.modCount;
    }

    public void insertBefore(T newItem, T existingItem) {
        Node<T> anchorNode = this.nodes.get(existingItem);
        Preconditions.checkArgument((anchorNode != null ? 1 : 0) != 0, (Object)ITEM_NOT_FOUND_WARNING);
        Preconditions.checkArgument((!this.nodes.containsKey(newItem) ? 1 : 0) != 0, (Object)DUPLICATE_ELEMENT_WARNING);
        Node newNode = new Node(anchorNode.previous, newItem, anchorNode);
        anchorNode.previous = newNode;
        if (newNode.previous != null) {
            newNode.previous.next = newNode;
        }
        if (anchorNode == this.firstNode) {
            this.firstNode = newNode;
        }
        this.nodes.put(newItem, newNode);
        ++this.modCount;
    }

    public T getFirst() {
        if (this.firstNode == null) {
            throw new NoSuchElementException();
        }
        return this.firstNode.item;
    }

    public T getLast() {
        if (this.lastNode == null) {
            throw new NoSuchElementException();
        }
        return this.lastNode.item;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodes.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter(this.firstNode);
    }

    @Override
    public Object[] toArray() {
        return Iterators.toArray(this.iterator(), Object.class);
    }

    @Override
    public <E> E[] toArray(E[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        E[] result = a;
        Node<T> x = this.firstNode;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        Object item = o;
        Node<T> node = this.nodes.remove(item);
        if (node == null) {
            return false;
        }
        this.unlink(node);
        ++this.modCount;
        return true;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.nodes.keySet().containsAll(c);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        if (this.size() > c.size()) {
            Iterator<?> i = c.iterator();
            while (i.hasNext()) {
                modified |= this.remove(i.next());
            }
        } else {
            Iterator<T> i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.firstNode = null;
        this.lastNode = null;
    }

    private T unlink(Node<T> x) {
        Object element = x.item;
        Node next = x.next;
        Node prev = x.previous;
        if (prev == null) {
            this.firstNode = next;
        } else {
            prev.next = next;
            x.previous = null;
        }
        if (next == null) {
            this.lastNode = prev;
        } else {
            next.previous = prev;
            x.next = null;
        }
        x.item = null;
        return element;
    }

    private static class Node<T> {
        T item;
        Node<T> next;
        Node<T> previous;

        Node(Node<T> previous, T element, Node<T> next) {
            this.item = element;
            this.next = next;
            this.previous = previous;
        }
    }

    private class Iter
    implements Iterator<T> {
        Node<T> currentNode;
        Node<T> lastNodeReturned = null;
        private int expectedModCount;

        Iter(Node<T> startingNode) {
            this.expectedModCount = HashedLinkedSequence.this.modCount;
            this.currentNode = startingNode;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public T next() {
            this.checkForComodification();
            if (this.currentNode == null) {
                throw new NoSuchElementException();
            }
            Object returnMe = this.currentNode.item;
            this.lastNodeReturned = this.currentNode;
            this.currentNode = this.currentNode.next;
            return returnMe;
        }

        final void checkForComodification() {
            if (HashedLinkedSequence.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastNodeReturned == null) {
                throw new IllegalStateException();
            }
            HashedLinkedSequence.this.remove(this.lastNodeReturned.item);
            this.lastNodeReturned = null;
            ++this.expectedModCount;
        }
    }
}

