/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.mitre.caasd.commons.Pair;
import org.mitre.caasd.commons.collect.CenterPointSelector;
import org.mitre.caasd.commons.collect.CenterPointSelectors;
import org.mitre.caasd.commons.collect.DistanceMetric;
import org.mitre.caasd.commons.collect.SetSearch;
import org.mitre.caasd.commons.collect.SetSearchResult;

public class MetricSet<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_SPHERE_SIZE = 50;
    private final CenterPointSelector<K> centerPointSelector;
    private final DistanceMetric<K> metric;
    private Sphere rootSphere;
    private int sphereCount = 0;
    private final int MAX_INNER_SPHERE_SIZE;
    private HashMap<K, Sphere> globalHashMap = new HashMap();

    public MetricSet(DistanceMetric<K> metric) {
        this(metric, 50);
        TreeMap tm = new TreeMap();
    }

    public MetricSet(DistanceMetric<K> metric, int maxSphereSize) {
        this(metric, maxSphereSize, CenterPointSelectors.maxOfRandomSamples());
    }

    public MetricSet(DistanceMetric<K> metric, int maxSphereSize, CenterPointSelector<K> selector) {
        Preconditions.checkNotNull(metric, (Object)"The input DistanceMetric cannot be null");
        Preconditions.checkArgument((maxSphereSize >= 4 ? 1 : 0) != 0, (Object)("The maxSphereSize must be at least 4, it was: " + maxSphereSize));
        Preconditions.checkNotNull(selector, (Object)"The CenterPointSelector cannot be null");
        this.metric = metric;
        this.centerPointSelector = selector;
        this.MAX_INNER_SPHERE_SIZE = maxSphereSize;
    }

    public final DistanceMetric<K> metric() {
        return this.metric;
    }

    public boolean add(K key) {
        Preconditions.checkNotNull(key);
        if (this.rootSphere == null) {
            this.rootSphere = new Sphere(key);
        }
        if (this.globalHashMap.containsKey(key)) {
            return false;
        }
        this.rootSphere.add(key);
        return true;
    }

    public boolean addAll(Collection<K> items) {
        boolean result = false;
        for (K item : items) {
            result |= this.add(item);
        }
        return result;
    }

    public int size() {
        return this.globalHashMap.size();
    }

    public boolean isEmpty() {
        return this.globalHashMap.isEmpty();
    }

    public boolean contains(K key) {
        return this.globalHashMap.containsKey(key);
    }

    public SetSearchResult<K> getClosest(K searchKey) {
        if (this.globalHashMap.containsKey(searchKey)) {
            Sphere sa = this.globalHashMap.get(searchKey);
            return new SetSearchResult<K>(searchKey, 0.0);
        }
        List<SetSearchResult<K>> results = this.getNClosest(searchKey, 1);
        ArrayList<SetSearchResult<K>> list = new ArrayList<SetSearchResult<K>>(results);
        return list.get(0);
    }

    public List<SetSearchResult<K>> getNClosest(K searchKey, int n) {
        Preconditions.checkArgument((boolean)Objects.nonNull(searchKey));
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1");
        }
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        SetSearch<K> q = new SetSearch<K>(searchKey, n, this.metric);
        q.startQuery(this.rootSphere);
        ArrayList<SetSearchResult<K>> list = new ArrayList<SetSearchResult<K>>(q.results());
        Collections.sort(list);
        return list;
    }

    public List<SetSearchResult<K>> getAllWithinRange(K searchKey, double range) {
        Preconditions.checkArgument((boolean)Objects.nonNull(searchKey));
        if (range <= 0.0) {
            throw new IllegalArgumentException("The range must be strictly positive " + range);
        }
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        SetSearch<K> q = new SetSearch<K>(searchKey, this.metric, range);
        q.startQuery(this.rootSphere);
        ArrayList<SetSearchResult<K>> list = new ArrayList<SetSearchResult<K>>(q.results());
        Collections.sort(list);
        return list;
    }

    public boolean remove(K exactKey) {
        Preconditions.checkArgument((boolean)Objects.nonNull(exactKey));
        Sphere sa = this.globalHashMap.remove(exactKey);
        if (sa != null) {
            boolean hadImpact = sa.remove(exactKey);
            if (!hadImpact) {
                throw new AssertionError((Object)"Unexpected state, hadImpact should always be true here becuase the key was found in the global map");
            }
            return hadImpact;
        }
        return false;
    }

    public void clear() {
        this.rootSphere = null;
        this.globalHashMap = new HashMap();
        this.sphereCount = 0;
    }

    public Set<K> keySet() {
        return this.globalHashMap.keySet();
    }

    public int sphereCount() {
        return this.sphereCount;
    }

    public MetricSet<K> makeBalancedCopy() {
        ArrayList listOfEntries = Lists.newArrayList(this.keySet());
        Collections.shuffle(listOfEntries);
        MetricSet<K> newSet = new MetricSet<K>(this.metric);
        newSet.addAll(listOfEntries);
        if (this.size() != newSet.size()) {
            throw new AssertionError((Object)"The rebalancing process changed the number of entries");
        }
        return newSet;
    }

    public void rebalance() {
        MetricSet<K> newMap = this.makeBalancedCopy();
        this.rootSphere = newMap.rootSphere;
        this.globalHashMap = newMap.globalHashMap;
        this.sphereCount = newMap.sphereCount;
    }

    private double verifiedDistance(K k1, K k2) {
        double dist = this.metric.distanceBtw(k1, k2);
        Preconditions.checkState((!Double.isNaN(dist) ? 1 : 0) != 0, (Object)"A distance measurement was NaN.");
        Preconditions.checkState((dist >= 0.0 ? 1 : 0) != 0, (Object)"A negative distance measurement was observed.");
        return dist;
    }

    class Sphere
    implements Serializable {
        final K centerPoint;
        private double radius;
        private SphereType type = SphereType.SPHERE_OF_POINTS;
        private Set<K> entries;
        private Pair<Sphere, Sphere> childSpheres;

        Sphere(K key) {
            this.centerPoint = key;
            this.entries = new HashSet();
            this.childSpheres = null;
            ++MetricSet.this.sphereCount;
        }

        double radius() {
            return this.radius;
        }

        boolean isSphereOfPoints() {
            return this.type == SphereType.SPHERE_OF_POINTS;
        }

        boolean isSphereOfSpheres() {
            return this.type == SphereType.SPHERE_OF_SPHERES;
        }

        Set<K> points() {
            return this.entries;
        }

        Pair<Sphere, Sphere> children() {
            return this.childSpheres;
        }

        boolean add(K key) {
            if (this.isFull()) {
                this.split();
            }
            this.radius = Math.max(this.radius, MetricSet.this.verifiedDistance(this.centerPoint, key));
            if (this.isSphereOfPoints()) {
                MetricSet.this.globalHashMap.put(key, this);
                return this.entries.add(key);
            }
            if (this.isSphereOfSpheres()) {
                Sphere child = this.findClosestChildSphere(key);
                return child.add(key);
            }
            throw new AssertionError((Object)"Should never get here, all SphereTypes covered");
        }

        private void split() {
            Pair<Sphere, Sphere> newNodes = this.splitSphereOfPoints();
            this.type = SphereType.SPHERE_OF_SPHERES;
            this.entries = null;
            this.childSpheres = newNodes;
        }

        boolean remove(K key) {
            if (this.isSphereOfPoints()) {
                return this.entries.remove(key);
            }
            throw new AssertionError((Object)"Should never get here.  This should only be called on \"Sphere of Points\"");
        }

        private boolean isFull() {
            return this.type == SphereType.SPHERE_OF_POINTS && this.entries.size() >= MetricSet.this.MAX_INNER_SPHERE_SIZE;
        }

        private Sphere findClosestChildSphere(K key) {
            double secondDist;
            double firstDist = MetricSet.this.verifiedDistance(key, this.childSpheres.first().centerPoint);
            if (firstDist < (secondDist = MetricSet.this.verifiedDistance(key, this.childSpheres.second().centerPoint))) {
                return this.childSpheres.first();
            }
            return this.childSpheres.second();
        }

        private Pair<Sphere, Sphere> splitSphereOfPoints() {
            Preconditions.checkState((this.type == SphereType.SPHERE_OF_POINTS ? 1 : 0) != 0, (Object)"Only SPHERE_OF_POINTS should be split");
            Pair centers = this.pickCentersForNewSpheres();
            Sphere part1 = new Sphere(centers.first());
            Sphere part2 = new Sphere(centers.second());
            this.moveEntriesToChildren(part1, part2);
            return new Pair<Sphere, Sphere>(part1, part2);
        }

        private Pair<K, K> pickCentersForNewSpheres() {
            return MetricSet.this.centerPointSelector.selectNewCenterPoints(Lists.newArrayList(this.entries), MetricSet.this.metric);
        }

        private void moveEntriesToChildren(Sphere part1, Sphere part2) {
            boolean tieBreaker = false;
            for (Object key : this.entries) {
                this.addToBestOf(part1, part2, key, tieBreaker);
                tieBreaker = !tieBreaker;
            }
        }

        private void addToBestOf(Sphere node1, Sphere node2, K entry, boolean tieBreaker) {
            double distanceTo1 = MetricSet.this.verifiedDistance(entry, node1.centerPoint);
            double distanceTo2 = MetricSet.this.verifiedDistance(entry, node2.centerPoint);
            Sphere bestSphere = null;
            bestSphere = distanceTo1 == distanceTo2 ? (tieBreaker ? node1 : node2) : (distanceTo1 < distanceTo2 ? node1 : node2);
            bestSphere.add(entry);
        }

        Set<K> entries() {
            if (this.isSphereOfPoints()) {
                return this.entries();
            }
            if (this.isSphereOfSpheres()) {
                HashSet set = new HashSet();
                set.addAll(this.childSpheres.first().entries());
                set.addAll(this.childSpheres.second().entries());
                return set;
            }
            throw new AssertionError((Object)"Should never get here, all SphereTypes covered");
        }
    }

    private static enum SphereType {
        SPHERE_OF_POINTS,
        SPHERE_OF_SPHERES;

    }
}

