/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.mitre.caasd.commons.Pair;
import org.mitre.caasd.commons.collect.CenterPointSelector;
import org.mitre.caasd.commons.collect.CenterPointSelectors;
import org.mitre.caasd.commons.collect.DistanceMetric;
import org.mitre.caasd.commons.collect.Search;
import org.mitre.caasd.commons.collect.SearchResult;

public class MetricTree<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_SPHERE_SIZE = 50;
    private final CenterPointSelector<K> centerPointSelector;
    private final DistanceMetric<K> metric;
    private Sphere rootSphere;
    private int sphereCount = 0;
    private final int MAX_INNER_SPHERE_SIZE;
    private HashMap<K, SphereAssignment<K, V>> globalHashMap = new HashMap();

    public MetricTree(DistanceMetric<K> metric) {
        this(metric, 50);
    }

    public MetricTree(DistanceMetric<K> metric, int maxSphereSize) {
        this(metric, maxSphereSize, CenterPointSelectors.maxOfRandomSamples());
    }

    public MetricTree(DistanceMetric<K> metric, int maxSphereSize, CenterPointSelector<K> selector) {
        Preconditions.checkNotNull(metric, (Object)"The input DistanceMetric cannot be null");
        Preconditions.checkArgument((maxSphereSize >= 4 ? 1 : 0) != 0, (Object)("The maxSphereSize must be at least 4, it was: " + maxSphereSize));
        Preconditions.checkNotNull(selector, (Object)"The CenterPointSelector cannot be null");
        this.metric = metric;
        this.centerPointSelector = selector;
        this.MAX_INNER_SPHERE_SIZE = maxSphereSize;
    }

    public final DistanceMetric<K> metric() {
        return this.metric;
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Null Keys are not permited because they cannot be placed in the metric space");
        }
        if (this.rootSphere == null) {
            this.rootSphere = new Sphere(key);
        }
        if (this.globalHashMap.containsKey(key)) {
            SphereAssignment<K, V> sa = this.globalHashMap.get(key);
            sa.sphere().entries.put(key, value);
            V prior = sa.updateValue(value);
            return prior;
        }
        Object prior = this.rootSphere.put(key, value);
        assert (prior == null) : "The prior should always be null because globalMap.containsKey was false";
        return prior;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public int size() {
        return this.globalHashMap.size();
    }

    public boolean isEmpty() {
        return this.globalHashMap.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.globalHashMap.containsKey(key);
    }

    public V get(K exactKey) {
        Preconditions.checkArgument((boolean)Objects.nonNull(exactKey));
        SphereAssignment<K, V> sa = this.globalHashMap.get(exactKey);
        return sa != null ? (V)sa.value() : null;
    }

    public SearchResult<K, V> getClosest(K searchKey) {
        if (this.globalHashMap.containsKey(searchKey)) {
            SphereAssignment<K, V> sa = this.globalHashMap.get(searchKey);
            return new SearchResult<K, V>(searchKey, sa.value(), 0.0);
        }
        List<SearchResult<K, V>> results = this.getNClosest(searchKey, 1);
        ArrayList<SearchResult<K, V>> list = new ArrayList<SearchResult<K, V>>(results);
        return list.get(0);
    }

    public List<SearchResult<K, V>> getNClosest(K searchKey, int n) {
        Preconditions.checkArgument((boolean)Objects.nonNull(searchKey));
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1");
        }
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        Search q = new Search(searchKey, n, this.metric);
        q.startQuery(this.rootSphere);
        ArrayList<SearchResult<K, V>> list = new ArrayList<SearchResult<K, V>>(q.results());
        Collections.sort(list);
        return list;
    }

    public List<SearchResult<K, V>> getAllWithinRange(K searchKey, double range) {
        Preconditions.checkArgument((boolean)Objects.nonNull(searchKey));
        if (range <= 0.0) {
            throw new IllegalArgumentException("The range must be strictly positive " + range);
        }
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        Search q = new Search(searchKey, this.metric, range);
        q.startQuery(this.rootSphere);
        ArrayList<SearchResult<K, V>> list = new ArrayList<SearchResult<K, V>>(q.results());
        Collections.sort(list);
        return list;
    }

    public V remove(K exactKey) {
        Preconditions.checkArgument((boolean)Objects.nonNull(exactKey));
        SphereAssignment<K, V> sa = this.globalHashMap.remove(exactKey);
        if (sa != null) {
            Object priorValue = sa.sphere().remove(exactKey);
            if (priorValue != sa.value()) {
                throw new AssertionError((Object)"the value found in the globalMap should match the value found in the tree structure");
            }
            return priorValue;
        }
        return null;
    }

    public void clear() {
        this.rootSphere = null;
        this.globalHashMap = new HashMap();
        this.sphereCount = 0;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.rootSphere.entrySet();
    }

    public Set<K> keySet() {
        return this.globalHashMap.keySet();
    }

    public int sphereCount() {
        return this.sphereCount;
    }

    public MetricTree<K, V> makeBalancedCopy() {
        ArrayList listOfEntries = Lists.newArrayList(this.entrySet());
        Collections.shuffle(listOfEntries);
        MetricTree newMap = new MetricTree(this.metric);
        for (Map.Entry entry : listOfEntries) {
            newMap.put(entry.getKey(), entry.getValue());
        }
        if (this.size() != newMap.size()) {
            throw new AssertionError((Object)"The rebalancing process changed the number of entries");
        }
        return newMap;
    }

    public void rebalance() {
        MetricTree<K, V> newMap = this.makeBalancedCopy();
        this.rootSphere = newMap.rootSphere;
        this.globalHashMap = newMap.globalHashMap;
        this.sphereCount = newMap.sphereCount;
    }

    private double verifiedDistance(K k1, K k2) {
        double dist = this.metric.distanceBtw(k1, k2);
        if (Double.isNaN(dist)) {
            throw new IllegalStateException("A distance measurement was NaN.");
        }
        if (dist < 0.0) {
            throw new IllegalStateException("A negative distance measurement was observed.");
        }
        return dist;
    }

    class Sphere
    implements Serializable {
        final K centerPoint;
        private double radius;
        private SphereState type = SphereState.SPHERE_OF_POINTS;
        private Map<K, V> entries;
        private Pair<Sphere, Sphere> childSpheres;

        Sphere(K key) {
            this.centerPoint = key;
            this.entries = new HashMap();
            this.childSpheres = null;
            ++MetricTree.this.sphereCount;
        }

        double radius() {
            return this.radius;
        }

        boolean isSphereOfPoints() {
            return this.type == SphereState.SPHERE_OF_POINTS;
        }

        boolean isSphereOfSpheres() {
            return this.type == SphereState.SPHERE_OF_SPHERES;
        }

        Set<Map.Entry<K, V>> points() {
            return this.entries.entrySet();
        }

        Pair<Sphere, Sphere> children() {
            return this.childSpheres;
        }

        V put(K key, V value) {
            if (this.isFull()) {
                this.split();
            }
            this.radius = Math.max(this.radius, MetricTree.this.verifiedDistance(this.centerPoint, key));
            if (this.isSphereOfPoints()) {
                MetricTree.this.globalHashMap.put(key, new SphereAssignment(this, value));
                return this.entries.put(key, value);
            }
            if (this.isSphereOfSpheres()) {
                Sphere child = this.findClosestChildSphere(key);
                return child.put(key, value);
            }
            throw new AssertionError((Object)"Should never get here, all SphereTypes covered");
        }

        private void split() {
            Pair<Sphere, Sphere> newNodes = this.splitSphereOfPoints();
            this.type = SphereState.SPHERE_OF_SPHERES;
            this.entries = null;
            this.childSpheres = newNodes;
        }

        V remove(K key) {
            if (this.isSphereOfPoints()) {
                return this.entries.remove(key);
            }
            throw new AssertionError((Object)"Should never get here.  This should only be called on \"Sphere of Points\"");
        }

        private boolean isFull() {
            return this.type == SphereState.SPHERE_OF_POINTS && this.entries.size() >= MetricTree.this.MAX_INNER_SPHERE_SIZE;
        }

        private Sphere findClosestChildSphere(K key) {
            double secondDist;
            double firstDist = MetricTree.this.verifiedDistance(key, this.childSpheres.first().centerPoint);
            if (firstDist < (secondDist = MetricTree.this.verifiedDistance(key, this.childSpheres.second().centerPoint))) {
                return this.childSpheres.first();
            }
            return this.childSpheres.second();
        }

        private Pair<Sphere, Sphere> splitSphereOfPoints() {
            if (this.type != SphereState.SPHERE_OF_POINTS) {
                throw new IllegalStateException("Only SPHERE_OF_POINTS should be split");
            }
            Pair centers = this.pickCentersForNewSpheres();
            Sphere part1 = new Sphere(centers.first());
            Sphere part2 = new Sphere(centers.second());
            this.moveEntriesToChildren(part1, part2);
            return new Pair<Sphere, Sphere>(part1, part2);
        }

        private Pair<K, K> pickCentersForNewSpheres() {
            return MetricTree.this.centerPointSelector.selectNewCenterPoints(new ArrayList(this.entries.keySet()), MetricTree.this.metric);
        }

        private void moveEntriesToChildren(Sphere part1, Sphere part2) {
            boolean tieBreaker = false;
            for (Map.Entry entry : this.entries.entrySet()) {
                this.addToBestOf(part1, part2, entry, tieBreaker);
                tieBreaker = !tieBreaker;
            }
        }

        private void addToBestOf(Sphere node1, Sphere node2, Map.Entry<K, V> entry, boolean tieBreaker) {
            double distanceTo1 = MetricTree.this.verifiedDistance(entry.getKey(), node1.centerPoint);
            double distanceTo2 = MetricTree.this.verifiedDistance(entry.getKey(), node2.centerPoint);
            Sphere bestSphere = null;
            bestSphere = distanceTo1 == distanceTo2 ? (tieBreaker ? node1 : node2) : (distanceTo1 < distanceTo2 ? node1 : node2);
            bestSphere.put(entry.getKey(), entry.getValue());
        }

        Set<Map.Entry<K, V>> entrySet() {
            if (this.isSphereOfPoints()) {
                return this.entries.entrySet();
            }
            if (this.isSphereOfSpheres()) {
                HashSet set = new HashSet();
                set.addAll(this.childSpheres.first().entrySet());
                set.addAll(this.childSpheres.second().entrySet());
                return set;
            }
            throw new AssertionError((Object)"Should never get here, all SphereTypes covered");
        }
    }

    static class SphereAssignment<KEY, VALUE> {
        private final Sphere currentSphere;
        private VALUE value;

        SphereAssignment(Sphere sphere, VALUE value) {
            this.currentSphere = sphere;
            this.value = value;
        }

        Sphere sphere() {
            return this.currentSphere;
        }

        VALUE value() {
            return this.value;
        }

        VALUE updateValue(VALUE newValue) {
            VALUE oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }
    }

    private static enum SphereState {
        SPHERE_OF_POINTS,
        SPHERE_OF_SPHERES;

    }
}

