/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.collect;

import com.google.common.primitives.Doubles;
import java.util.Objects;

public class SetSearchResult<K>
implements Comparable<SetSearchResult<K>> {
    final K key;
    final double distance;

    SetSearchResult(K key, double distance) {
        this.key = key;
        this.distance = distance;
    }

    public K key() {
        return this.key;
    }

    public double distance() {
        return this.distance;
    }

    @Override
    public int compareTo(SetSearchResult<K> other) {
        return Doubles.compare((double)other.distance, (double)this.distance);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.key);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.distance) ^ Double.doubleToLongBits(this.distance) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetSearchResult other = (SetSearchResult)obj;
        if (Double.doubleToLongBits(this.distance) != Double.doubleToLongBits(other.distance)) {
            return false;
        }
        return Objects.equals(this.key, other.key);
    }
}

