/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.fileutil;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.mitre.caasd.commons.fileutil.FileLineIterator;
import org.mitre.caasd.commons.util.DemotedException;

public class FileUtils {
    private static final byte GZ_MAGIC_BYTE_0 = 31;
    private static final byte GZ_MAGIC_BYTE_1 = -117;
    private static final byte GZ_MAGIC_BYTE_2 = 8;

    public static BufferedReader createReaderFor(File file) throws IOException {
        if (FileUtils.isGZipFile(file)) {
            return FileUtils.createReaderForGZipFile(file);
        }
        return new BufferedReader(new FileReader(file));
    }

    public static boolean isGZipFile(File file) throws IOException {
        byte[] byteBuffer = new byte[3];
        try (FileInputStream fis = new FileInputStream(file);){
            fis.read(byteBuffer);
        }
        return byteBuffer[0] == 31 && byteBuffer[1] == -117;
    }

    public static PrintWriter buildGzWriter(File targetGzFile) throws IOException {
        Preconditions.checkNotNull((Object)targetGzFile);
        Preconditions.checkArgument((boolean)targetGzFile.getName().endsWith(".gz"));
        FileOutputStream fos = new FileOutputStream(targetGzFile);
        GZIPOutputStream gos = new GZIPOutputStream(fos);
        return new PrintWriter(gos);
    }

    public static ArrayList<String> fileLines(File f) {
        FileLineIterator fli = new FileLineIterator(f);
        return Streams.stream((Iterator)fli).collect(Collectors.toCollection(ArrayList::new));
    }

    public static ArrayList<String> gzFileLines(File f) {
        return FileUtils.fileLines(f);
    }

    public static Iterator<String> fileLineIter(File f) {
        return new FileLineIterator(f);
    }

    public static Iterator<String> gzFileLineIter(File f) {
        return new FileLineIterator(f);
    }

    public static BufferedReader createReaderForGZipFile(File file) throws IOException {
        InputStream fileStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader(gzipStream);
        return new BufferedReader(decoder);
    }

    public static void appendToFile(String fileName, String writeMe) throws Exception {
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)writeMe);
        FileUtils.appendToFile(new File(fileName), writeMe);
    }

    public static void appendToFile(File file, String writeMe) throws Exception {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)writeMe);
        FileUtils.writeToFile(file, writeMe, true);
    }

    public static void writeToNewFile(File file, String writeMe) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)writeMe);
        FileUtils.writeToFile(file, writeMe, false);
    }

    private static void writeToFile(File file, String writeMe, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, append);
        PrintWriter dout = new PrintWriter(fos);
        dout.write(writeMe);
        dout.close();
        fos.close();
    }

    public static void writeToNewFile(String fileName, String writeMe) throws IOException {
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)writeMe);
        FileUtils.writeToNewFile(new File(fileName), writeMe);
    }

    public static void writeToNewGzFile(String fileName, String writeMe) throws IOException {
        Preconditions.checkNotNull((Object)fileName);
        Preconditions.checkNotNull((Object)writeMe);
        FileUtils.writeToNewGzFile(new File(fileName), writeMe);
    }

    public static void writeToNewGzFile(File aGzFile, String writeMe) throws IOException {
        Preconditions.checkArgument(("gz".equals(com.google.common.io.Files.getFileExtension((String)aGzFile.getName())) || "gzip".equals(com.google.common.io.Files.getFileExtension((String)aGzFile.getName())) ? 1 : 0) != 0, (Object)("The output file " + String.valueOf(aGzFile) + " does not have the extension .gz or .gzip"));
        FileOutputStream fos = new FileOutputStream(aGzFile);
        GZIPOutputStream gos = new GZIPOutputStream(fos);
        PrintWriter dout = new PrintWriter(gos);
        dout.write(writeMe);
        dout.close();
        gos.finish();
        gos.close();
        fos.close();
    }

    public static void serialize(Serializable ser, File targetFile) {
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(targetFile.toPath(), new OpenOption[0]));){
            oos.writeObject(ser);
        }
        catch (Exception ex) {
            throw DemotedException.demote(ex);
        }
    }

    public static void serialize(Serializable ser, String fileName) {
        FileUtils.serialize(ser, new File(fileName));
    }

    public static Object deserialize(File f) {
        Object object;
        Preconditions.checkNotNull((Object)f, (Object)"Cannot deserialize a null file");
        Preconditions.checkArgument((boolean)f.exists(), (Object)("Cannot deserialize: " + f.getAbsolutePath() + " because the file does not exists"));
        ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));
        try {
            Object obj = ois.readObject();
            ois.close();
            object = obj;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException ex) {
                throw DemotedException.demote(ex);
            }
        }
        ois.close();
        return object;
    }

    public static Object deserialize(InputStream inputStream) {
        try {
            ObjectInputStream ois = new ObjectInputStream(inputStream);
            Object obj = ois.readObject();
            ois.close();
            inputStream.close();
            return obj;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw DemotedException.demote(ex);
        }
    }

    public static Properties getProperties(File propertiesFile) throws IOException {
        class PropertiesThatWontPutTwice
        extends Properties {
            PropertiesThatWontPutTwice() {
            }

            @Override
            public synchronized Object put(Object key, Object value) {
                Object prior = super.put(key, value);
                if (prior != null) {
                    throw new IllegalArgumentException("The property: " + String.valueOf(key) + " was already set");
                }
                return prior;
            }
        }
        PropertiesThatWontPutTwice props = new PropertiesThatWontPutTwice();
        try (InputStream input = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
            props.load(input);
        }
        Properties output = new Properties();
        output.putAll((Map<?, ?>)props);
        return output;
    }

    public static void makeDirIfMissing(String dir) {
        FileUtils.makeDirIfMissing(new File(dir));
    }

    public static void makeDirIfMissing(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Unable to delete directory " + String.valueOf(directory) + ".");
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = String.valueOf(directory) + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = String.valueOf(directory) + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + String.valueOf(directory));
        }
        IOException exception = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                FileUtils.forceDelete(file);
                continue;
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + String.valueOf(file));
            }
            if (!file.delete()) {
                throw new IOException("Unable to delete file: " + String.valueOf(file));
            }
        }
    }

    public static Optional<File> getResourceAsFile(Class clazz, String filename) {
        ClassLoader classLoader = clazz.getClassLoader();
        File file = new File(classLoader.getResource(filename).getFile());
        if (file.exists()) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public static File getResourceFile(String filename) {
        URL url = Resources.getResource((String)filename);
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw DemotedException.demote("Classpath resource " + String.valueOf(url) + " cannot be resolved.", e);
        }
    }
}

