/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.ids;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import org.mitre.caasd.commons.HasTime;
import org.mitre.caasd.commons.util.BitAndHashingUtils;

public class TimeId
implements Comparable<TimeId>,
HasTime,
Serializable {
    private static final long serialVersionUID = 3013947926990530136L;
    private static final Base64.Encoder BASE_64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final int NUM_TIMESTAMP_BITS = 42;
    private static final int NUM_RAND_BITS_ON_LEFT = 22;
    private static final long TIME_BIT_MASK = BitAndHashingUtils.makeBitMask(42);
    private static final long NON_TIME_BIT_MASK = BitAndHashingUtils.makeBitMask(22);
    private final long leftBits;
    private final long rightBits;
    private static final long SIXTY_THREE_BIT_MASK = Long.parseLong("7fffffffffffffff", 16);

    public TimeId(Instant time) {
        SecureRandom ng = Holder.RNG;
        long timeBasedBits = TIME_BIT_MASK & time.toEpochMilli();
        long nonTimeBits = NON_TIME_BIT_MASK & ng.nextLong();
        this.leftBits = timeBasedBits << 22 | nonTimeBits;
        this.rightBits = ng.nextLong();
    }

    public static TimeId newIdFor(Instant time) {
        return new TimeId(time);
    }

    public static TimeId newId() {
        return new TimeId(Instant.now());
    }

    private TimeId(long leftBits, long rightBits) {
        this.leftBits = leftBits;
        this.rightBits = rightBits;
    }

    public TimeId(byte[] exactly16Bytes) {
        int i;
        Objects.requireNonNull(exactly16Bytes);
        Preconditions.checkArgument((exactly16Bytes.length == 16 ? 1 : 0) != 0, (Object)"Must use exactly 16 bytes");
        long bigBits = 0L;
        long smallBits = 0L;
        for (i = 0; i < 8; ++i) {
            bigBits = bigBits << 8 | (long)(exactly16Bytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            smallBits = smallBits << 8 | (long)(exactly16Bytes[i] & 0xFF);
        }
        this.leftBits = bigBits;
        this.rightBits = smallBits;
    }

    public byte[] bytes() {
        return ByteBuffer.allocate(16).putLong(this.leftBits).putLong(this.rightBits).array();
    }

    public byte[] randomBytes() {
        long randomBits = this.leftBits & NON_TIME_BIT_MASK;
        return ByteBuffer.allocate(16).putLong(randomBits).putLong(this.rightBits).array();
    }

    public double asUniformRand() {
        long randomBits = this.rightBits & SIXTY_THREE_BIT_MASK;
        long maxPossibleValue = SIXTY_THREE_BIT_MASK;
        return (double)randomBits / (double)maxPossibleValue;
    }

    public String asBase64() {
        return BASE_64_ENCODER.encodeToString(this.bytes());
    }

    public String rngBitsAsBase64() {
        return this.asBase64().substring(7);
    }

    public static TimeId fromBase64(String str) {
        Objects.requireNonNull(str);
        byte[] exactly16Bytes = Base64.getUrlDecoder().decode(str);
        return new TimeId(exactly16Bytes);
    }

    public String toString() {
        return this.asBase64();
    }

    public static TimeId fromString(String str) {
        Objects.requireNonNull(str);
        return TimeId.fromBase64(str);
    }

    public String asHexString() {
        return String.format("%016x", this.leftBits) + String.format("%016x", this.rightBits);
    }

    public static TimeId fromHexString(String hexStr) {
        Objects.requireNonNull(hexStr);
        Preconditions.checkArgument((hexStr.length() == 32 ? 1 : 0) != 0, (Object)"A 32 character hex string is expected");
        BigInteger left = new BigInteger(hexStr.substring(0, 16), 16);
        BigInteger right = new BigInteger(hexStr.substring(16, 32), 16);
        return new TimeId(left.longValue(), right.longValue());
    }

    @Override
    public Instant time() {
        return Instant.ofEpochMilli(this.leftBits >> 22);
    }

    @Override
    public long timeAsEpochMs() {
        return this.leftBits >> 22;
    }

    public int hashCode() {
        long hilo = this.leftBits ^ this.rightBits;
        return (int)(hilo >> 32) ^ (int)hilo;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != TimeId.class) {
            return false;
        }
        TimeId id = (TimeId)obj;
        return this.leftBits == id.leftBits && this.rightBits == id.rightBits;
    }

    @Override
    public int compareTo(TimeId val) {
        return this.leftBits < val.leftBits ? -1 : (this.leftBits > val.leftBits ? 1 : (this.rightBits < val.rightBits ? -1 : (this.rightBits > val.rightBits ? 1 : 0)));
    }

    private static class Holder {
        static final SecureRandom RNG = new SecureRandom();

        private Holder() {
        }
    }
}

