/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.lambda;

import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mitre.caasd.commons.lambda.CheckedBiFunction;
import org.mitre.caasd.commons.lambda.CheckedBinaryOperator;
import org.mitre.caasd.commons.lambda.CheckedCallable;
import org.mitre.caasd.commons.lambda.CheckedConsumer;
import org.mitre.caasd.commons.lambda.CheckedFunction;
import org.mitre.caasd.commons.lambda.CheckedPredicate;
import org.mitre.caasd.commons.lambda.CheckedRunnable;
import org.mitre.caasd.commons.lambda.CheckedSupplier;
import org.mitre.caasd.commons.util.DemotedException;

public class Uncheck {
    public static <S, T> Function<S, T> func(CheckedFunction<S, T> func) {
        return x -> {
            try {
                return func.apply(x);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw DemotedException.demote(e);
            }
        };
    }

    public static <T> Predicate<T> pred(CheckedPredicate<T> pred) {
        return x -> {
            try {
                return pred.test(x);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw DemotedException.demote(e);
            }
        };
    }

    public static <T> Consumer<T> consumer(CheckedConsumer<T> consumer) {
        return x -> {
            try {
                consumer.accept(x);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw DemotedException.demote(e);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> biFunc(CheckedBiFunction<T, U, R> biFunc) {
        return (t, u) -> {
            try {
                return biFunc.apply(t, u);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw DemotedException.demote(e);
            }
        };
    }

    public static <T> BinaryOperator<T> biOp(CheckedBinaryOperator<T> binaryOperator) {
        return (t, u) -> {
            try {
                return binaryOperator.apply(t, u);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw DemotedException.demote(e);
            }
        };
    }

    public static <T> Supplier<T> supplier(CheckedSupplier<T> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw DemotedException.demote(e);
            }
        };
    }

    public static void run(CheckedRunnable checkedRunnable) {
        try {
            checkedRunnable.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw DemotedException.demote(e);
        }
    }

    public static <T> T call(CheckedCallable<T> checkedCallable) {
        try {
            return checkedCallable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw DemotedException.demote(e);
        }
    }
}

