/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.Objects;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.maps.FeatureSet;
import org.mitre.caasd.commons.maps.MapFeature;
import org.mitre.caasd.commons.maps.MapFeatures;

public class FeatureSetBuilder {
    List<MapFeature> features = Lists.newArrayList();
    Color currentColor = null;
    Integer currentCircleDiameter = null;
    Float currentStrokeWidth = null;
    Font currentFont = new Font("Avenir", 0, 32);

    public static FeatureSetBuilder newFeatureSetBuilder() {
        return new FeatureSetBuilder();
    }

    public FeatureSetBuilder setColor(Color c) {
        this.currentColor = c;
        return this;
    }

    public FeatureSetBuilder setCircleDiameter(int diameterInPixels) {
        this.currentCircleDiameter = diameterInPixels;
        return this;
    }

    public FeatureSetBuilder setStrokeWidth(float stroke) {
        this.currentStrokeWidth = Float.valueOf(stroke);
        return this;
    }

    public FeatureSetBuilder setFont(Font font) {
        Objects.requireNonNull(font);
        this.currentFont = font;
        return this;
    }

    public FeatureSetBuilder addFeature(MapFeature feature) {
        Objects.requireNonNull(feature);
        this.features.add(feature);
        return this;
    }

    public FeatureSetBuilder addCircle(LatLong location, Color color, int diameterInPixels, float strokeWidth) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(color);
        this.features.add(MapFeatures.circle(location, color, diameterInPixels, strokeWidth));
        return this;
    }

    public FeatureSetBuilder addCircle(LatLong location, Color color, int diameterInPixels) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(color);
        Objects.requireNonNull(this.currentStrokeWidth);
        this.features.add(MapFeatures.circle(location, color, diameterInPixels, this.currentStrokeWidth.floatValue()));
        return this;
    }

    public FeatureSetBuilder addCircle(LatLong location, Color color) {
        Objects.requireNonNull(this.currentCircleDiameter);
        Objects.requireNonNull(this.currentStrokeWidth);
        return this.addCircle(location, color, this.currentCircleDiameter, this.currentStrokeWidth.floatValue());
    }

    public FeatureSetBuilder addCircle(LatLong location) {
        Objects.requireNonNull(this.currentColor);
        Objects.requireNonNull(this.currentCircleDiameter);
        Objects.requireNonNull(this.currentStrokeWidth);
        return this.addCircle(location, this.currentColor, this.currentCircleDiameter, this.currentStrokeWidth.floatValue());
    }

    public FeatureSetBuilder addFilledCircle(LatLong location, Color color, int diameterInPixels) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(color);
        this.features.add(MapFeatures.filledCircle(location, color, diameterInPixels));
        return this;
    }

    public FeatureSetBuilder addFilledCircle(LatLong location, Color color) {
        Objects.requireNonNull(this.currentCircleDiameter);
        return this.addFilledCircle(location, color, this.currentCircleDiameter);
    }

    public FeatureSetBuilder addFilledCircle(LatLong location) {
        Objects.requireNonNull(this.currentColor);
        Objects.requireNonNull(this.currentCircleDiameter);
        return this.addFilledCircle(location, this.currentColor, this.currentCircleDiameter);
    }

    public FeatureSetBuilder addLine(LatLong from, LatLong to, Color color, float stroke) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(color);
        this.features.add(MapFeatures.line(from, to, color, stroke));
        return this;
    }

    public FeatureSetBuilder addLine(LatLong from, LatLong to, Color color) {
        Objects.requireNonNull(this.currentStrokeWidth);
        return this.addLine(from, to, color, this.currentStrokeWidth.floatValue());
    }

    public FeatureSetBuilder addLine(LatLong from, LatLong to) {
        Objects.requireNonNull(this.currentColor);
        Objects.requireNonNull(this.currentStrokeWidth);
        return this.addLine(from, to, this.currentColor, this.currentStrokeWidth.floatValue());
    }

    public FeatureSetBuilder addShape(List<LatLong> pts, Color color) {
        Objects.requireNonNull(pts);
        Objects.requireNonNull(color);
        this.features.add(MapFeatures.shape(pts, color));
        return this;
    }

    public FeatureSetBuilder addFilledShape(List<LatLong> pts, Color color) {
        Objects.requireNonNull(pts);
        Objects.requireNonNull(color);
        this.features.add(MapFeatures.filledShape(pts, color));
        return this;
    }

    public FeatureSetBuilder addPath(List<LatLong> pts, Color color, float strokeWidth) {
        Objects.requireNonNull(pts);
        Objects.requireNonNull(color);
        this.features.add(MapFeatures.path(pts, color, strokeWidth));
        return this;
    }

    public FeatureSetBuilder addText(String message, int xOffset, int yOffset, Color c, Font font) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(c);
        Objects.requireNonNull(font);
        this.features.add(MapFeatures.text(message, xOffset, yOffset, c, font));
        return this;
    }

    public FeatureSetBuilder addText(String message, int xOffset, int yOffset, Color c) {
        Objects.requireNonNull(this.currentFont);
        return this.addText(message, xOffset, yOffset, c, this.currentFont);
    }

    public FeatureSetBuilder addText(String message, int xOffset, int yOffset) {
        Objects.requireNonNull(this.currentFont);
        Objects.requireNonNull(this.currentFont);
        return this.addText(message, xOffset, yOffset, this.currentColor, this.currentFont);
    }

    public FeatureSetBuilder addText(String message, LatLong anchor, Color c, Font font) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(anchor);
        Objects.requireNonNull(c);
        Objects.requireNonNull(font);
        this.features.add(MapFeatures.text(message, anchor, c, font));
        return this;
    }

    public FeatureSetBuilder addText(String message, LatLong anchor, Color c) {
        Objects.requireNonNull(this.currentFont);
        return this.addText(message, anchor, c, this.currentFont);
    }

    public FeatureSetBuilder addText(String message, LatLong anchor) {
        Objects.requireNonNull(this.currentColor);
        Objects.requireNonNull(this.currentFont);
        return this.addText(message, anchor, this.currentColor, this.currentFont);
    }

    public FeatureSet build() {
        return new FeatureSet(this.features);
    }
}

