/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.maps.DebugTileServer;
import org.mitre.caasd.commons.maps.LocallyCachingTileServer;
import org.mitre.caasd.commons.maps.MapBoxApi;
import org.mitre.caasd.commons.maps.MapFeature;
import org.mitre.caasd.commons.maps.MapImage;
import org.mitre.caasd.commons.maps.MonochromeTileServer;
import org.mitre.caasd.commons.maps.TileServer;

public class MapBuilder {
    private TileServer tileServer = null;
    private LatLong center = null;
    private Distance distanceWidth = null;
    private Integer pixelWidth = null;
    private Integer zoomLevel = null;
    private boolean useDiskCaching = false;
    private Duration cacheRetention = null;
    private final List<MapFeature> featureList = Lists.newArrayList();

    public static MapBuilder newMapBuilder() {
        return new MapBuilder();
    }

    public MapBuilder tileSource(TileServer source) {
        Objects.requireNonNull(source);
        Preconditions.checkState((this.tileServer == null ? 1 : 0) != 0, (Object)"The tileServer was already set");
        this.tileServer = source;
        return this;
    }

    public MapBuilder solidBackground(Color c) {
        return this.tileSource(new MonochromeTileServer(c));
    }

    public MapBuilder debugTiles() {
        return this.tileSource(new DebugTileServer());
    }

    public MapBuilder mapBoxDarkMode() {
        return this.tileSource(new MapBoxApi(MapBoxApi.Style.DARK));
    }

    public MapBuilder mapBoxSatelliteMode() {
        return this.tileSource(new MapBoxApi(MapBoxApi.Style.SATELLITE));
    }

    public MapBuilder mapBoxLightMode() {
        return this.tileSource(new MapBoxApi(MapBoxApi.Style.LIGHT));
    }

    public MapBuilder center(LatLong center) {
        Objects.requireNonNull(center, "map center cannot be null");
        this.center = center;
        return this;
    }

    public MapBuilder width(Distance width) {
        Objects.requireNonNull(width, "width cannot be null");
        Preconditions.checkState((boolean)Objects.isNull(this.distanceWidth), (Object)"width cannot be set twice, width(Distance) was already called");
        Preconditions.checkState((boolean)Objects.isNull(this.pixelWidth), (Object)"width cannot be set twice, width(pixelWidth, zoom) was already called");
        Preconditions.checkState((boolean)Objects.isNull(this.zoomLevel), (Object)"width cannot be set twice, width(pixelWidth, zoom) was already called");
        this.distanceWidth = width;
        return this;
    }

    public MapBuilder width(int widthInPixels, int zoomLevel) {
        Preconditions.checkArgument((widthInPixels > 0 ? 1 : 0) != 0, (Object)"widthInPixels must be positive");
        Preconditions.checkArgument((zoomLevel >= 0 ? 1 : 0) != 0, (Object)"zoomLevel must be at least 0");
        Preconditions.checkState((boolean)Objects.isNull(this.distanceWidth), (Object)"width cannot be set twice, width(Distance) was already called");
        Preconditions.checkState((boolean)Objects.isNull(this.pixelWidth), (Object)"width cannot be set twice, width(pixelWidth, zoom) was already called");
        this.pixelWidth = widthInPixels;
        this.zoomLevel = zoomLevel;
        return this;
    }

    public MapBuilder useLocalDiskCaching(Duration cacheRetention) {
        Objects.requireNonNull(cacheRetention);
        Preconditions.checkArgument((cacheRetention.getSeconds() > 0L ? 1 : 0) != 0, (Object)"cacheRetention must be greater than 0 seconds");
        this.useDiskCaching = true;
        this.cacheRetention = cacheRetention;
        return this;
    }

    public MapBuilder addFeature(MapFeature feature) {
        Objects.requireNonNull(feature, "The MapFeature cannot be null");
        this.featureList.add(feature);
        return this;
    }

    public <T> MapBuilder addFeature(T obj, Function<T, MapFeature> renderer) {
        Objects.requireNonNull(obj, "The obj to render cannot be null");
        Objects.requireNonNull(renderer, "The MapFeature renderer cannot be null");
        return this.addFeature(renderer.apply(obj));
    }

    public MapBuilder addFeatures(MapFeature ... features) {
        Objects.requireNonNull(features, "The MapFeature varags cannot be null");
        Collections.addAll(this.featureList, features);
        return this;
    }

    public MapBuilder addFeatures(Iterable<MapFeature> features) {
        Objects.requireNonNull(features, "The Iterable<MapFeature> cannot be null");
        for (MapFeature feature : features) {
            this.featureList.add(feature);
        }
        return this;
    }

    public <T> MapBuilder addFeatures(Collection<T> objects, Function<T, MapFeature> renderer) {
        List<MapFeature> asMapFeatures = objects.stream().map(renderer).collect(Collectors.toList());
        return this.addFeatures(asMapFeatures);
    }

    public MapImage buildWithoutFeatures() {
        TileServer source;
        Objects.requireNonNull(this.tileServer, "tileServer cannot be null");
        Objects.requireNonNull(this.center, "center cannot be null");
        if (Objects.isNull(this.distanceWidth) && Objects.isNull(this.pixelWidth)) {
            throw new NullPointerException("The width not set");
        }
        TileServer tileServer = source = this.useDiskCaching ? new LocallyCachingTileServer(this.tileServer, this.cacheRetention) : this.tileServer;
        if (Objects.nonNull(this.distanceWidth)) {
            return new MapImage(source, this.center, this.distanceWidth);
        }
        return new MapImage(source, this.center, this.pixelWidth, this.zoomLevel);
    }

    public BufferedImage toImage() {
        return this.buildWithoutFeatures().plot(this.featureList);
    }

    public void toFile(File targetFile) {
        this.buildWithoutFeatures().plotToFile(this.featureList, targetFile);
    }
}

