/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Objects;
import org.mitre.caasd.commons.maps.TileAddress;
import org.mitre.caasd.commons.maps.TileServer;

public class MonochromeTileServer
implements TileServer {
    private final Color color;
    private final int tileSize = 512;

    public MonochromeTileServer(Color color) {
        Objects.requireNonNull(color);
        this.color = color;
    }

    @Override
    public int maxZoomLevel() {
        return 20;
    }

    @Override
    public int maxTileSize() {
        return 512;
    }

    @Override
    public URL getUrlFor(TileAddress ta) {
        throw new UnsupportedOperationException("URLs are not provided because single color tiles can be created directly");
    }

    @Override
    public BufferedImage downloadMap(TileAddress tile) {
        BufferedImage img = new BufferedImage(512, 512, 5);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(this.color);
        g.fillRect(0, 0, 512, 512);
        return img;
    }
}

