/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.maps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.mitre.caasd.commons.LatLong;
import org.mitre.caasd.commons.maps.PixelLatLong;

public class TileAddress {
    private final int xIndex;
    private final int yIndex;
    private final int zoomLevel;

    public TileAddress(int x, int y, int zoomLevel) {
        Preconditions.checkArgument((x >= 0 ? 1 : 0) != 0);
        this.xIndex = x;
        this.yIndex = y;
        this.zoomLevel = zoomLevel;
    }

    public int xIndex() {
        return this.xIndex;
    }

    public int yIndex() {
        return this.yIndex;
    }

    public int zoomLevel() {
        return this.zoomLevel;
    }

    public String tileUrlComponent() {
        return this.zoomLevel + "/" + this.xIndex + "/" + this.yIndex;
    }

    public String toString() {
        return this.zoomLevel + "-" + this.xIndex + "-" + this.yIndex;
    }

    public PixelLatLong topLeftPixel(int tileSize) {
        return new PixelLatLong(this.xIndex * tileSize, this.yIndex * tileSize, this.zoomLevel, tileSize);
    }

    public PixelLatLong bottomRightPixel(int tileSize) {
        return new PixelLatLong(this.xIndex * tileSize + tileSize, this.yIndex * tileSize + tileSize, this.zoomLevel, tileSize);
    }

    public static TileAddress of(LatLong loc, int zoom) {
        int scale = 1 << zoom;
        double xFraction = (loc.longitude() + 180.0) / 360.0;
        double yFraction = (1.0 - Math.log(Math.tan(Math.toRadians(loc.latitude())) + 1.0 / Math.cos(Math.toRadians(loc.latitude()))) / Math.PI) / 2.0;
        int xTile = (int)Math.floor(xFraction * (double)scale);
        int yTile = (int)Math.floor(yFraction * (double)scale);
        if (xTile < 0) {
            xTile = 0;
        }
        if (xTile >= scale) {
            xTile = scale - 1;
        }
        if (yTile < 0) {
            yTile = 0;
        }
        if (yTile >= scale) {
            yTile = scale - 1;
        }
        return new TileAddress(xTile, yTile, zoom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileAddress that = (TileAddress)o;
        return this.xIndex == that.xIndex && this.yIndex == that.yIndex && this.zoomLevel == that.zoomLevel;
    }

    public int hashCode() {
        return Objects.hash(this.xIndex, this.yIndex, this.zoomLevel);
    }

    public static TileAddress getTileAddress(double lat, double lon, int zoom) {
        return TileAddress.of(LatLong.of(lat, lon), zoom);
    }

    public static Comparator<TileAddress> cornerFinder() {
        return (o1, o2) -> {
            int thisSum = o1.xIndex + o1.yIndex;
            int thatSum = o2.xIndex + o2.yIndex;
            return Integer.compare(thisSum, thatSum);
        };
    }

    public static List<TileAddress> tileAddressesSpanning(TileAddress topLeft, TileAddress bottomRight, int zoom) {
        ArrayList tiles = Lists.newArrayList();
        for (int x = topLeft.xIndex(); x <= bottomRight.xIndex(); ++x) {
            for (int y = topLeft.yIndex(); y <= bottomRight.yIndex(); ++y) {
                tiles.add(new TileAddress(x, y, zoom));
            }
        }
        return tiles;
    }

    public static List<TileAddress> tileAddressesSpanning(LatLong topLeft, LatLong bottomRight, int zoomLevel) {
        return TileAddress.tileAddressesSpanning(TileAddress.of(topLeft, zoomLevel), TileAddress.of(bottomRight, zoomLevel), zoomLevel);
    }
}

