/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;

public class CurveFitters {
    public static double fitAndPredict(int polynomialDegree, List<Double> xData, List<Double> yData, double predictHere) {
        Preconditions.checkArgument((xData.size() == yData.size() ? 1 : 0) != 0);
        int n = xData.size();
        List<Double> equalWeights = IntStream.range(0, n).mapToObj(i -> 1.0).collect(Collectors.toList());
        return CurveFitters.fitAndPredict(polynomialDegree, equalWeights, xData, yData, predictHere);
    }

    public static double fitAndPredict(int polynomialDegree, List<Double> weights, List<Double> xData, List<Double> yData, double predictHere) {
        PolynomialFunction func = CurveFitters.weightedFit(polynomialDegree, weights, xData, yData);
        return func.value(predictHere);
    }

    public static PolynomialFunction fit(int polynomialDegree, List<Double> xData, List<Double> yData) {
        Preconditions.checkArgument((xData.size() == yData.size() ? 1 : 0) != 0);
        int n = xData.size();
        List<Double> equalWeights = IntStream.range(0, n).mapToObj(i -> 1.0).collect(Collectors.toList());
        return CurveFitters.weightedFit(polynomialDegree, equalWeights, xData, yData);
    }

    public static PolynomialFunction weightedFit(int polynomialDegree, List<Double> weights, List<Double> xData, List<Double> yData) {
        Preconditions.checkArgument((weights.size() == xData.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((xData.size() == yData.size() ? 1 : 0) != 0);
        int n = xData.size();
        List pts = IntStream.range(0, n).mapToObj(i -> new WeightedObservedPoint(((Double)weights.get(i)).doubleValue(), ((Double)xData.get(i)).doubleValue(), ((Double)yData.get(i)).doubleValue())).collect(Collectors.toList());
        PolynomialCurveFitter pcf = PolynomialCurveFitter.create((int)polynomialDegree);
        double[] polynomialCoef = pcf.fit(pts);
        return new PolynomialFunction(polynomialCoef);
    }
}

