/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import java.util.List;
import org.mitre.caasd.commons.math.XyDataset;

@FunctionalInterface
public interface DataSplitter {
    public int[] computeSplitsFor(List<Double> var1, List<Double> var2);

    default public int[] computeSplitsFor(XyDataset dataset) {
        return this.computeSplitsFor(dataset.xData(), dataset.yData());
    }

    default public XyDataset[] split(XyDataset dataset) {
        return dataset.split(this);
    }

    public static void checkInputData(List<Double> xData, List<Double> yData) {
        Preconditions.checkNotNull(xData);
        Preconditions.checkNotNull(yData);
        Preconditions.checkArgument((xData.size() == yData.size() ? 1 : 0) != 0, (Object)"The xData and yData have different sizes");
        DataSplitter.checkOrdering(xData);
    }

    public static void checkOrdering(List<Double> xData) {
        double last = Double.NEGATIVE_INFINITY;
        for (Double cur : xData) {
            if (cur <= last) {
                throw new IllegalArgumentException("The input is not sorted");
            }
            last = cur;
        }
    }
}

