/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.mitre.caasd.commons.math.DataSplitter;
import org.mitre.caasd.commons.math.FastLinearApproximation;

public class QuasiOptimalSplitter
implements DataSplitter {
    private static final int NO_MORE_SPLITS = -1;
    private final double targetAverageSquaredError;

    public QuasiOptimalSplitter(double targetAverageSquaredError) {
        this.targetAverageSquaredError = targetAverageSquaredError;
    }

    @Override
    public int[] computeSplitsFor(List<Double> xData, List<Double> yData) {
        DataSplitter.checkInputData(xData, yData);
        int n = xData.size();
        TreeSet boundaryIndexValues = Sets.newTreeSet();
        boundaryIndexValues.add(0);
        boundaryIndexValues.add(n);
        this.recursivelySplitDataset(xData, yData, 0, n, boundaryIndexValues);
        return Ints.toArray((Collection)boundaryIndexValues);
    }

    private void recursivelySplitDataset(List<Double> xData, List<Double> yData, int minIndex, int maxIndex, TreeSet<Integer> chops) {
        int splitIndex = this.determineSplitFor(xData, yData, minIndex, maxIndex);
        if (splitIndex == -1) {
            return;
        }
        chops.add(splitIndex);
        this.recursivelySplitDataset(xData, yData, minIndex, splitIndex, chops);
        this.recursivelySplitDataset(xData, yData, splitIndex, maxIndex, chops);
    }

    private int determineSplitFor(List<Double> xData, List<Double> yData, int minIndex, int maxIndex) {
        Preconditions.checkArgument((minIndex < maxIndex ? 1 : 0) != 0);
        if (maxIndex - minIndex < 4) {
            return -1;
        }
        double minErrorSoFar = Double.POSITIVE_INFINITY;
        int indexOfMinError = -1;
        for (int i = minIndex + 1; i < maxIndex - 1; ++i) {
            FastLinearApproximation left = new FastLinearApproximation(xData.subList(minIndex, i), yData.subList(minIndex, i));
            FastLinearApproximation right = new FastLinearApproximation(xData.subList(i, maxIndex), yData.subList(i, maxIndex));
            double thisError = left.totalSquaredError() + right.totalSquaredError();
            if (!(thisError < minErrorSoFar)) continue;
            indexOfMinError = i;
            minErrorSoFar = thisError;
        }
        double n = maxIndex - minIndex;
        double averageError = minErrorSoFar / n;
        return averageError > this.targetAverageSquaredError ? indexOfMinError + 1 : -1;
    }
}

