/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;

public class ReservoirSampler<T>
implements Consumer<T> {
    private final ArrayList<T> samples;
    private final Random rng;
    private final int sampleSize;
    private int countSeen = 0;

    public ReservoirSampler(int sampleSize) {
        this(sampleSize, new Random());
    }

    public ReservoirSampler(int sampleSize, Random random) {
        Objects.requireNonNull(random);
        Preconditions.checkArgument((sampleSize >= 0 ? 1 : 0) != 0);
        this.sampleSize = sampleSize;
        this.samples = new ArrayList(sampleSize);
        this.rng = random;
        this.countSeen = 0;
    }

    @Override
    public void accept(T item) {
        if (this.countSeen < this.sampleSize) {
            this.samples.add(item);
        } else {
            int randomIndex = this.rng.nextInt(this.countSeen + 1);
            if (randomIndex < this.sampleSize) {
                this.samples.set(randomIndex, item);
            }
        }
        ++this.countSeen;
    }

    public ArrayList<T> currentSample() {
        return new ArrayList<T>(this.samples);
    }

    public int countSeen() {
        return this.countSeen;
    }

    public int sampleSize() {
        return this.sampleSize;
    }

    public void reset() {
        this.samples.clear();
        this.countSeen = 0;
    }
}

