/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class Vector {
    private final double[] components;

    public Vector(double ... components) {
        Preconditions.checkNotNull((Object)components);
        Preconditions.checkArgument((components.length > 0 ? 1 : 0) != 0, (Object)"Vectors must have at least one component.");
        this.components = components;
    }

    public static Vector of(double ... components) {
        return new Vector(components);
    }

    public double[] components() {
        return Arrays.copyOf(this.components, this.components.length);
    }

    public double component(int i) {
        return this.components[i];
    }

    public int dimension() {
        return this.components.length;
    }

    public Vector plus(Vector other) {
        Preconditions.checkNotNull((Object)other);
        Vector.checkDimensionsAreEqual(this, other);
        double[] sum = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            sum[i] = this.components[i] + other.components[i];
        }
        return Vector.of(sum);
    }

    public Vector minus(Vector other) {
        Vector.checkDimensionsAreEqual(this, other);
        double[] difference = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            difference[i] = this.components[i] - other.components[i];
        }
        return Vector.of(difference);
    }

    public Vector times(double scalar) {
        double[] rescaled = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            rescaled[i] = this.components[i] * scalar;
        }
        return Vector.of(rescaled);
    }

    public double dot(Vector other) {
        Vector.checkDimensionsAreEqual(this, other);
        double sum = 0.0;
        for (int i = 0; i < this.components.length; ++i) {
            sum += this.components[i] * other.components[i];
        }
        return sum;
    }

    public double magnitude() {
        return FastMath.sqrt((double)this.dot(this));
    }

    public static void checkDimensionsAreEqual(Vector v1, Vector v2) {
        Preconditions.checkArgument((v1.components.length == v2.components.length ? 1 : 0) != 0, (Object)"These vectors have different dimensions");
    }
}

