/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mitre.caasd.commons.math.DataSplitter;
import org.mitre.caasd.commons.math.VisvalingamSimplifier;
import org.mitre.caasd.commons.math.XyDataset;

public class VisvalingamSplitter
implements DataSplitter {
    private final VisvalingamSimplifier simplifier;
    private final double IMPORTANT_TRIANGLE_THRESHOLD;

    public VisvalingamSplitter(double importantTriangleThreshold) {
        Preconditions.checkArgument((importantTriangleThreshold >= 0.0 ? 1 : 0) != 0);
        this.simplifier = new VisvalingamSimplifier();
        this.IMPORTANT_TRIANGLE_THRESHOLD = importantTriangleThreshold;
    }

    @Override
    public int[] computeSplitsFor(List<Double> xData, List<Double> yData) {
        XyDataset data = new XyDataset(xData, yData);
        XyDataset keyPoints = this.simplifier.simplify(data, this.IMPORTANT_TRIANGLE_THRESHOLD);
        ArrayList indicesOfKeyPoints = keyPoints.xData().stream().map(xValue -> xData.indexOf(xValue)).collect(Collectors.toCollection(ArrayList::new));
        int n = indicesOfKeyPoints.size();
        int prior = (Integer)indicesOfKeyPoints.get(n - 1);
        indicesOfKeyPoints.set(n - 1, prior + 1);
        return Ints.toArray((Collection)indicesOfKeyPoints);
    }
}

