/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mitre.caasd.commons.math.DataSplitter;
import org.mitre.caasd.commons.math.FastLinearApproximation;
import org.mitre.caasd.commons.math.XyPoint;

public class XyDataset {
    private final List<Double> xData;
    private final List<Double> yData;
    private FastLinearApproximation approx;

    public XyDataset(List<Double> xData, List<Double> yData) {
        DataSplitter.checkInputData(xData, yData);
        this.xData = xData;
        this.yData = yData;
    }

    public List<Double> xData() {
        return this.xData;
    }

    public List<Double> yData() {
        return this.yData;
    }

    public int size() {
        return this.xData.size();
    }

    public FastLinearApproximation approximateFit() {
        if (this.approx == null) {
            this.approx = new FastLinearApproximation(this.xData, this.yData);
        }
        return this.approx;
    }

    public double slopeEstimate() {
        return this.approximateFit().slope();
    }

    public double avgSquaredErrorEstimate() {
        return this.approximateFit().avgSquaredError();
    }

    public double length() {
        return this.xData.get(this.xData.size() - 1) - this.xData.get(0);
    }

    public XyDataset[] split(DataSplitter splitter) {
        int[] splitIndices = splitter.computeSplitsFor(this.xData, this.yData);
        XyDataset[] splits = new XyDataset[splitIndices.length - 1];
        for (int i = 0; i < splitIndices.length - 1; ++i) {
            splits[i] = new XyDataset(this.xData.subList(splitIndices[i], splitIndices[i + 1]), this.yData.subList(splitIndices[i], splitIndices[i + 1]));
        }
        return splits;
    }

    public ArrayList<XyPoint> asXyPointList() {
        ArrayList<XyPoint> list = new ArrayList<XyPoint>(this.xData.size());
        Iterator<Double> xIter = this.xData.iterator();
        Iterator<Double> yIter = this.yData.iterator();
        while (xIter.hasNext()) {
            list.add(new XyPoint(xIter.next(), yIter.next()));
        }
        return list;
    }

    public XyDataset takeDerivative() {
        ArrayList xCopy = Lists.newArrayList(this.xData);
        ArrayList yCopy = Lists.newArrayList();
        int n = xCopy.size();
        for (int i = 0; i < n; ++i) {
            double slopeToPrior;
            if (i == 0) {
                double slopeToNext = (this.yData.get(i + 1) - this.yData.get(i)) / (this.xData.get(i + 1) - this.xData.get(i));
                yCopy.add(slopeToNext);
                continue;
            }
            if (i == n - 1) {
                slopeToPrior = (this.yData.get(i) - this.yData.get(i - 1)) / (this.xData.get(i) - this.xData.get(i - 1));
                yCopy.add(slopeToPrior);
                continue;
            }
            slopeToPrior = (this.yData.get(i) - this.yData.get(i - 1)) / (this.xData.get(i) - this.xData.get(i - 1));
            double slopeToNext = (this.yData.get(i + 1) - this.yData.get(i)) / (this.xData.get(i + 1) - this.xData.get(i));
            double slopeBetween = (this.yData.get(i + 1) - this.yData.get(i - 1)) / (this.xData.get(i + 1) - this.xData.get(i - 1));
            double avgSlope = (slopeToPrior + slopeToNext + slopeBetween) / 3.0;
            yCopy.add(avgSlope);
        }
        return new XyDataset(xCopy, yCopy);
    }
}

