/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.math.locationfit;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.mitre.caasd.commons.Distance;
import org.mitre.caasd.commons.KineticPosition;
import org.mitre.caasd.commons.Position;
import org.mitre.caasd.commons.Speed;
import org.mitre.caasd.commons.TimeWindow;
import org.mitre.caasd.commons.math.CurveFitters;
import org.mitre.caasd.commons.math.locationfit.GaussianWindow;
import org.mitre.caasd.commons.math.locationfit.LatLongFitter;
import org.mitre.caasd.commons.math.locationfit.PositionInterpolator;

public class LocalPolyInterpolator
implements PositionInterpolator {
    private final GaussianWindow weightedWindow;
    private final int requiredPoints;
    private final boolean ignoreAltitude;

    public LocalPolyInterpolator(Duration windowSize) {
        this(windowSize, 3, false);
    }

    public LocalPolyInterpolator(Duration windowSize, int requiredPoints) {
        this(windowSize, requiredPoints, false);
    }

    public LocalPolyInterpolator(Duration windowSize, int requiredPoints, boolean ignoreAltitude) {
        this.weightedWindow = new GaussianWindow(windowSize);
        this.requiredPoints = requiredPoints;
        this.ignoreAltitude = ignoreAltitude;
    }

    @Override
    public Optional<KineticPosition> interpolate(List<Position> positionData, Instant sampleTime) {
        TimeWindow sampleWindow = this.weightedWindow.windowCenteredAt(sampleTime);
        List<Position> pointsInSampleWindow = positionData.stream().filter(pt -> sampleWindow.contains(pt.time())).collect(Collectors.toList());
        long numUniqueTimes = pointsInSampleWindow.stream().map(pt -> pt.time()).distinct().count();
        if (numUniqueTimes < (long)this.requiredPoints) {
            return Optional.empty();
        }
        TimeWindow dataSupportedWindow = TimeWindow.of(((Position)pointsInSampleWindow.get(0)).time(), ((Position)pointsInSampleWindow.get(pointsInSampleWindow.size() - 1)).time());
        if (!dataSupportedWindow.contains(sampleTime)) {
            return Optional.empty();
        }
        long sampleEpochTime = sampleTime.toEpochMilli();
        ArrayList timesAsEpochMs = Lists.newArrayList();
        ArrayList weights = Lists.newArrayList();
        ArrayList locations = Lists.newArrayList();
        List<Double> altitudes = this.extractAltitudes(pointsInSampleWindow);
        for (Position pt2 : pointsInSampleWindow) {
            timesAsEpochMs.add(Double.valueOf(pt2.timeAsEpochMs() - sampleEpochTime));
            weights.add(this.weightedWindow.computeGaussianWeight(sampleTime, pt2.time()));
            locations.add(pt2.latLong());
        }
        LatLongFitter fitter = new LatLongFitter(weights, timesAsEpochMs, locations);
        PolynomialFunction altitudeFunction = this.ignoreAltitude ? new PolynomialFunction(new double[]{0.0, 0.0}) : CurveFitters.weightedFit(1, weights, timesAsEpochMs, altitudes);
        LatLongFitter.KineticValues deductions = fitter.fitKineticsAtTimeZero();
        KineticPosition kinetics = KineticPosition.builder().time(sampleTime).latLong(deductions.latLong()).altitude(this.deduceAltitude(altitudeFunction)).climbRate(this.deduceClimbRate(altitudeFunction)).speed(deductions.speed()).course(deductions.course()).acceleration(deductions.acceleration()).turnRate(fitter.deduceTurnRate()).build();
        return Optional.of(kinetics);
    }

    private <T> List<Double> extractAltitudes(List<Position> pointsInSampleWindow) {
        return this.ignoreAltitude ? Lists.newArrayList() : pointsInSampleWindow.stream().map(pt -> pt.altitude().inFeet()).collect(Collectors.toList());
    }

    private Distance deduceAltitude(PolynomialFunction altitudeFunction) {
        double altitudeInFt = altitudeFunction.value(0.0);
        return Distance.ofFeet(altitudeInFt);
    }

    private Speed deduceClimbRate(PolynomialFunction altitudeFunction) {
        double climbRateInFtPerMilli = altitudeFunction.derivative().value(0.0);
        return Speed.of(climbRateInFtPerMilli, Speed.Unit.FEET_PER_MINUTE);
    }
}

