/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.out;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import org.mitre.caasd.commons.Functions;
import org.mitre.caasd.commons.fileutil.FileUtils;
import org.mitre.caasd.commons.out.JsonWritable;
import org.mitre.caasd.commons.out.OutputSink;
import org.mitre.caasd.commons.util.ExceptionHandler;
import org.mitre.caasd.commons.util.SequentialFileWriter;

public class JsonFileSink<T extends JsonWritable>
implements OutputSink<T> {
    private final String outputDirectory;
    private final ExceptionHandler exceptionHandler;
    private final Functions.ToStringFunction<T> fileNamer;
    private final Function<T, Path> subdirectoryStrategy;

    public JsonFileSink(String outputDirectory, Functions.ToStringFunction<T> fileNamer) {
        this(outputDirectory, fileNamer, JsonFileSink.noSubdirectories());
    }

    public JsonFileSink(String outputDirectory, Functions.ToStringFunction<T> fileNamer, Function<T, Path> subDir) {
        this(outputDirectory, fileNamer, subDir, new SequentialFileWriter("jsonWritingErrors"));
    }

    JsonFileSink(String outputDirectory, Functions.ToStringFunction<T> fileNamer, Function<T, Path> subDir, ExceptionHandler exceptionHandler) {
        this.outputDirectory = outputDirectory;
        this.exceptionHandler = (ExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler);
        this.fileNamer = (Functions.ToStringFunction)Preconditions.checkNotNull(fileNamer, (Object)"The file-naming function cannot be null");
        this.subdirectoryStrategy = (Function)Preconditions.checkNotNull(subDir);
    }

    @Override
    public void accept(T event) {
        Path subdirectory = this.subdirectoryStrategy.apply(event);
        this.writeRecordToFile(event.asJson() + "\n", subdirectory, (String)this.fileNamer.apply(event));
    }

    private void writeRecordToFile(String json, Path subdirectory, String filePrefix) {
        try {
            Path targetDirectory = Paths.get(this.outputDirectory, new String[0]).resolve(subdirectory);
            JsonFileSink.makeDirs(targetDirectory.toFile());
            String fullPath = targetDirectory.resolve(filePrefix + ".json").normalize().toAbsolutePath().toString();
            FileUtils.appendToFile(fullPath, json);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle("Error creating a file to contain a " + JsonWritable.class.getSimpleName(), ex);
        }
    }

    static void makeDirs(File candidate) throws IOException {
        candidate.mkdirs();
        if (!candidate.isDirectory()) {
            throw new IOException("Unable to create candidate '" + String.valueOf(candidate) + "'");
        }
    }

    public static <T> Function<T, Path> noSubdirectories() {
        Path empty = Paths.get("", new String[0]);
        return in -> empty;
    }
}

