/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.out;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public interface OutputSink<T>
extends Consumer<T>,
Closeable,
Flushable {
    @Override
    public void accept(T var1);

    @Override
    default public void flush() throws IOException {
    }

    @Override
    default public void close() throws IOException {
    }

    @Override
    default public OutputSink<T> andThen(OutputSink<T> after) {
        return new CompositeSink(this, after);
    }

    @SafeVarargs
    public static <K> OutputSink<K> combine(OutputSink<K> ... destinations) {
        return new CompositeSink<K>(destinations);
    }

    public static <K> OutputSink<K> combine(List<OutputSink<K>> allSinks) {
        return new CompositeSink<K>(allSinks);
    }

    public static class CompositeSink<K>
    implements OutputSink<K> {
        private final ArrayList<OutputSink<K>> destinations;

        @SafeVarargs
        private CompositeSink(OutputSink<K> ... destinations) {
            Preconditions.checkNotNull(destinations);
            this.destinations = Lists.newArrayList((Object[])destinations);
        }

        private CompositeSink(List<OutputSink<K>> sinks) {
            Preconditions.checkNotNull(sinks);
            this.destinations = Lists.newArrayList(sinks);
        }

        @Override
        public void accept(K record) {
            for (OutputSink<K> destination : this.destinations) {
                destination.accept(record);
            }
        }

        @Override
        public void close() throws IOException {
            for (OutputSink<K> destination : this.destinations) {
                destination.close();
            }
        }
    }
}

