/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.out;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.mitre.caasd.commons.Functions;
import org.mitre.caasd.commons.fileutil.FileUtils;
import org.mitre.caasd.commons.out.OutputSink;
import org.mitre.caasd.commons.util.DemotedException;

public class PrintStreamSink<T>
implements OutputSink<T> {
    private final Functions.ToStringFunction<T> stringConverter;
    private final PrintStream stream;

    public PrintStreamSink(Functions.ToStringFunction<T> formatter, PrintStream stream) {
        this.stringConverter = (Functions.ToStringFunction)Preconditions.checkNotNull(formatter);
        this.stream = (PrintStream)Preconditions.checkNotNull((Object)stream);
    }

    public static <T> PrintStreamSink<T> writeRecordToFlatFile(String outputDirectory, Functions.ToStringFunction<T> formatter) {
        FileUtils.makeDirIfMissing(outputDirectory);
        File outputFile = new File(outputDirectory, "eventRecords.txt");
        try {
            return new PrintStreamSink<T>(formatter, new PrintStream(outputFile));
        }
        catch (FileNotFoundException fnfe) {
            throw DemotedException.demote(fnfe);
        }
    }

    @Override
    public void accept(T item) {
        String converted = (String)this.stringConverter.apply(item);
        this.stream.println(converted);
    }

    @Override
    public void close() {
        this.stream.close();
    }
}

