/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.out;

import java.util.Collection;
import java.util.Objects;
import org.mitre.caasd.commons.out.OutputSink;

public class Sinks {
    public static <T> OutputSink<T> noOpSink() {
        return new NoOpSink();
    }

    public static <T> CollectionSink<T> collectionSink(Collection<T> addToMe) {
        return new CollectionSink<T>(addToMe);
    }

    public static class NoOpSink<T>
    implements OutputSink<T> {
        @Override
        public void accept(T record) {
        }
    }

    public static class CollectionSink<T>
    implements OutputSink<T> {
        private final Collection<T> col;

        public CollectionSink(Collection<T> col) {
            this.col = Objects.requireNonNull(col);
        }

        @Override
        public void accept(T record) {
            this.col.add(record);
        }

        public Collection<T> collection() {
            return this.col;
        }
    }
}

