/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class LeftMerger<T> {
    private final BiPredicate<T, T> mergeable;
    private final BiFunction<T, T, T> mergeLeft;

    public LeftMerger(BiPredicate<T, T> mergeable, BiFunction<T, T, T> mergeLeft) {
        this.mergeable = mergeable;
        this.mergeLeft = mergeLeft;
    }

    public boolean mergeable(T o1, T o2) {
        return this.mergeable.test(o1, o2);
    }

    public T mergeLeft(T o1, T o2) {
        return this.mergeLeft.apply(o1, o2);
    }

    public List<T> reduce(List<T> mergables) {
        ArrayList<T> reduced = new ArrayList<T>();
        if (!mergables.isEmpty()) {
            T ele = mergables.get(0);
            for (int i = 1; i < mergables.size(); ++i) {
                T next = mergables.get(i);
                if (this.mergeable(ele, next)) {
                    ele = this.mergeLeft(ele, next);
                    continue;
                }
                reduced.add(ele);
                ele = next;
            }
            reduced.add(ele);
        }
        return reduced;
    }

    public boolean nullMergeable(T m1, T m2) {
        Preconditions.checkArgument((null != m2 || null != m1 ? 1 : 0) != 0);
        return null == m1 || null == m2 || this.mergeable(m1, m2);
    }

    public T nullableMerge(T m1, T m2) {
        Preconditions.checkArgument((boolean)this.nullMergeable(m1, m2));
        return null == m1 ? m2 : (null == m2 ? m1 : this.mergeLeft(m1, m2));
    }

    public Collector<T, List<T>, List<T>> asCollector() {
        return new Collector<T, List<T>, List<T>>(){

            @Override
            public Supplier<List<T>> supplier() {
                return ArrayList::new;
            }

            @Override
            public BiConsumer<List<T>, T> accumulator() {
                return (list, next) -> {
                    if (list.isEmpty()) {
                        list.add(next);
                    } else {
                        Object last = list.get(list.size() - 1);
                        if (LeftMerger.this.mergeable(last, next)) {
                            list.set(list.size() - 1, LeftMerger.this.mergeLeft(last, next));
                        } else {
                            list.add(next);
                        }
                    }
                };
            }

            @Override
            public BinaryOperator<List<T>> combiner() {
                return (l1, l2) -> {
                    l1.addAll(l2);
                    return l1;
                };
            }

            @Override
            public Function<List<T>, List<T>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.singleton(Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }
}

