/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated
public class MemoryIterator<T>
implements Iterator<T> {
    private final Iterator<T> iter;
    private T prior;
    private boolean hasPrior;

    public MemoryIterator(Collection<T> collection) {
        this(collection.iterator());
    }

    @SafeVarargs
    public MemoryIterator(T ... array) {
        this((Collection<T>)Arrays.asList(array));
    }

    public MemoryIterator(Iterator<T> iter) {
        this.iter = (Iterator)Preconditions.checkNotNull(iter);
        this.prior = null;
        this.hasPrior = false;
    }

    public static <T> MemoryIterator<T> newMemoryIterator(Iterator<T> iter) {
        return new MemoryIterator<T>(iter);
    }

    public static <T> MemoryIterator<T> newMemoryIterator(Collection<T> collection) {
        return new MemoryIterator<T>(collection);
    }

    @SafeVarargs
    public static <T> MemoryIterator<T> newMemoryIterator(T ... array) {
        return new MemoryIterator<T>(array);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public T next() {
        this.prior = this.iter.next();
        this.hasPrior = true;
        return this.prior;
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    public boolean hasPrior() {
        return this.hasPrior;
    }

    public T prior() {
        if (this.hasPrior) {
            return this.prior;
        }
        throw new NoSuchElementException("There is no prior element");
    }

    public boolean atFront() {
        return this.hasNext() && !this.hasPrior;
    }

    public boolean inMiddle() {
        return this.hasNext() && this.hasPrior;
    }

    public boolean atEnd() {
        return !this.hasNext() && this.hasPrior;
    }

    public boolean isEmpty() {
        return !this.hasNext() && !this.hasPrior;
    }
}

