/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.mitre.caasd.commons.util.IterPair;

public class NeighborIterator<T>
implements Iterator<IterPair<T>> {
    private final Iterator<T> iterator;
    private T prior;
    private T current;
    private int elementCount = 0;

    @SafeVarargs
    public NeighborIterator(T ... array) {
        this((Collection<T>)Arrays.asList(array));
    }

    public NeighborIterator(Collection<T> collection) {
        this(collection.iterator());
    }

    public NeighborIterator(Iterator<T> iter) {
        this.iterator = Objects.requireNonNull(iter);
        this.prior = null;
        if (iter.hasNext()) {
            this.next();
        }
    }

    public static <T> NeighborIterator<T> newNeighborIterator(Iterator<T> iter) {
        return new NeighborIterator<T>(iter);
    }

    public static <T> NeighborIterator<T> newNeighborIterator(Collection<T> collection) {
        return new NeighborIterator<T>(collection);
    }

    @SafeVarargs
    public static <T> NeighborIterator<T> newNeighborIterator(T ... array) {
        return new NeighborIterator<T>(array);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public IterPair<T> next() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prior = this.current;
        this.current = this.iterator.next();
        ++this.elementCount;
        return new IterPair<T>(this.prior, this.current);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean wasEmpty() {
        return !this.hasNext() && this.elementCount == 0;
    }

    public boolean hadExactlyOneElement() {
        return !this.hasNext() && this.elementCount == 1;
    }

    public T getSoleElement() {
        if (this.hadExactlyOneElement()) {
            return this.current;
        }
        throw new IllegalStateException("Iterator did not have exactly one element");
    }
}

