/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mitre.caasd.commons.util.AwaitableTask;
import org.mitre.caasd.commons.util.ErrorCatchingTask;
import org.mitre.caasd.commons.util.ExceptionHandler;
import org.mitre.caasd.commons.util.SequentialFileWriter;

public class Parallelizer {
    private final ExecutorService service;
    private final ExceptionHandler errorHandler;
    private boolean isSpent = false;

    public Parallelizer(int numThreads) {
        this(numThreads, new SequentialFileWriter());
    }

    public Parallelizer(int numThreads, ExceptionHandler exceptionHandler) {
        this.service = Executors.newFixedThreadPool(numThreads);
        this.errorHandler = exceptionHandler;
    }

    public void doWorkInParallel(Runnable[] jobs) {
        Preconditions.checkState((!this.isSpent ? 1 : 0) != 0, (Object)"This Parallelizer is spent -- it cannot be reused");
        Preconditions.checkNotNull((Object)jobs, (Object)"Cannot submit a null array of Runnable objects");
        for (Runnable job : jobs) {
            Preconditions.checkNotNull((Object)job, (Object)"The input array of Runnable objects cannot contain a null");
        }
        CountDownLatch latch = new CountDownLatch(jobs.length);
        for (Runnable job : jobs) {
            AwaitableTask wrappedJob = new AwaitableTask(latch, new ErrorCatchingTask(job, this.errorHandler));
            this.service.submit(wrappedJob);
        }
        this.waitForJobsToFinish(latch);
        this.isSpent = true;
        this.service.shutdown();
    }

    public void doWorkInParallel(Collection<? extends Runnable> jobs) {
        this.doWorkInParallel(jobs.toArray(new Runnable[0]));
    }

    private void waitForJobsToFinish(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (Exception ex) {
            this.errorHandler.handle(ex);
        }
    }
}

