/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.collect.Streams;
import java.util.Objects;
import java.util.function.Function;

public class Preconditions {
    public static void checkNoNullElement(Iterable<?> items) {
        com.google.common.base.Preconditions.checkNotNull(items);
        for (Object item : items) {
            com.google.common.base.Preconditions.checkNotNull(item);
        }
    }

    public static void checkNoNullElement(Object[] items) {
        com.google.common.base.Preconditions.checkNotNull((Object)items);
        for (Object item : items) {
            com.google.common.base.Preconditions.checkNotNull((Object)item);
        }
    }

    public static <T> void checkAllTrue(Iterable<T> items, Function<T, Boolean> rule) {
        Objects.requireNonNull(items);
        Objects.requireNonNull(rule);
        for (T item : items) {
            com.google.common.base.Preconditions.checkArgument((boolean)rule.apply(item));
        }
    }

    public static <T> void checkAllFalse(Iterable<T> items, Function<T, Boolean> rule) {
        Objects.requireNonNull(items);
        Objects.requireNonNull(rule);
        for (T item : items) {
            com.google.common.base.Preconditions.checkArgument((rule.apply(item) == false ? 1 : 0) != 0);
        }
    }

    public static <T, U> void checkAllMatch(Iterable<T> items, Function<T, U> extractor) {
        Objects.requireNonNull(items);
        Objects.requireNonNull(extractor);
        long count = Streams.stream(items).map(extractor).distinct().count();
        com.google.common.base.Preconditions.checkArgument((count == 1L ? 1 : 0) != 0);
    }
}

